% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{elem_cache}
\alias{elem_cache}
\title{Force an element to be collected and stored}
\usage{
elem_cache(x, timeout = NULL)
}
\arguments{
\item{x}{A \code{selenider_element}/\code{selenider_elements} object.}

\item{timeout}{How long to wait for the element(s) to exist while collecting
them.}
}
\value{
A modified version of \code{x}. The result of \code{elem_cache()} can be used
as a normal \code{selenider_element}/\code{selenider_elements} object.
}
\description{
\code{selenider_element}/\code{selenider_elements} objects are generally
\emph{lazy}, meaning they only collect the actual element in the DOM
when absolutely necessary, and forget it immediately after. This
is to avoid situations where the DOM changes after an element
has been collected, resulting in errors and unreliable behaviour.

\code{elem_cache()} forces an element or collection of elements to be collected
and stored, making it eager rather than lazy. This is useful when you are
operating on the same element multiple times, since only collecting the
element once will improve performance. However, you must be sure that the
element will not change on the page while you are using it.
}
\details{
These functions do not make selenider elements \emph{permanently} eager. Further
sub-elements will not be cached unless specified.

For example, consider the following code:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{s(".class1") |>
  elem_parent() |>
  elem_cache() |>
  find_element(".class2")
}\if{html}{\out{</div>}}

In this example, the parent of the element with class ".class1" will be
cached, but the child element with class ".class2" will not.
}
\examples{
\dontshow{if (selenider::selenider_available(online = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
html <- "
<div>
<p id='specifictext'></p>
<button></button>
</div>
"

session <- minimal_selenider_session(html)

# Selecting this button may be slow, since we are using relative XPath
# selectors.
button <- s("#specifictext") |>
  elem_siblings() |>
  elem_find(has_name("button"))

# But we need to click the button 10 times!
# Normally, this would involve fetching the button from the DOM 10 times
click_button_10_times <- function(x) {
  lapply(1:10, \(unnused) elem_click(x))
  invisible(NULL)
}

# But with elem_cache(), the button will only be fetched once
cached_button <- elem_cache(button)

click_button_10_times(cached_button)

# But the cached button is less reliable if the DOM is changing
execute_js_fn("x => { x.outerHTML = '<button></button>'; }", button)

try(elem_click(cached_button, timeout = 0.1))

# But the non-cached version works
elem_click(button)
\dontshow{\}) # examplesIf}
}
\seealso{
\itemize{
\item \code{\link[=find_element]{find_element()}} and \code{\link[=find_elements]{find_elements()}} to select elements.
\item \code{\link[=as.list.selenider_elements]{as.list.selenider_elements()}}, \code{\link[=find_each_element]{find_each_element()}} and
\code{\link[=find_all_elements]{find_all_elements()}} if you want to iterate over an element collection.
}
}
