% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi.R
\name{iter.array}
\alias{iter.array}
\title{Iterator over array}
\usage{
\method{iter}{array}(obj, by = 1, recycle = FALSE, ...)
}
\arguments{
\item{obj}{An array.}

\item{by}{The dimension to iterate over.}

\item{recycle}{Should the iterator reset?}

\item{...}{not used}
}
\value{
An iterator. This is an S3 arrayiter object, used in conjunction
with nextElem to iterate over one index of an array.
}
\description{
Iterator over array
}
\examples{
glist <- multidog_to_g(
  mout = ufit,
  ploidy = 4,
  type = "all_gl",
  p1 = "indigocrisp",
  p2 = "sweetcrisp")
g <- iterators::iter(glist$g, by = 3)
head(iterators::nextElem(g))
head(iterators::nextElem(g))
head(iterators::nextElem(g))

}
\seealso{
\code{\link[=nextElem.arrayiter]{nextElem.arrayiter()}}
}
\author{
David Gerard
}
