% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/higher_freq.R
\name{gamfreq}
\alias{gamfreq}
\title{Gamete frequencies under a generalized model}
\usage{
gamfreq(
  g,
  ploidy,
  gamma = NULL,
  alpha = NULL,
  beta = NULL,
  type = c("mix", "polysomic"),
  add_dr = TRUE
)
}
\arguments{
\item{g}{Parent genotype.}

\item{ploidy}{Parent ploidy. Should be even, and between 2 and 20 (inclusive).
Let me know if you need the ploidy to be higher. I can update
the package really easily.}

\item{gamma}{The mixture proportions for the pairing configurations.
The proportions are in the same order the configurations in
\code{\link{seg}}. See Gerard et al (2018) for details on
pairing configurations.}

\item{alpha}{The double reduction rate(s) (if using). Defaults to 0's.}

\item{beta}{The double reduction adjustment for simplex markers if
\code{type = "mix"} and \code{add_dr = TRUE}. Assumed to be 0 by default.}

\item{type}{Either \code{"mix"}, meaning a mixture model of
pairing configurations, or \code{"polysomic"} for polysomic inheritance.}

\item{add_dr}{A logical. If \code{type = "polysomic"}, then the double
double reduction rate (\code{"alpha"}) will be used no matter the
value of \code{add_dr}, so set \code{alpha = 0} if you don't want it.
But if \code{type = "mix"} then we will incorporate double reduction
only in simplex markers (where it matters the most, and where
preferential pairing does not operate).}
}
\value{
The vector of gamete frequencies. Element \code{i} is the
probability a gamete has genotype \code{i - 1}.
}
\description{
Returns the gamete frequencies for autopolyploids, allopolyploids,
and segmental allopolyploids, accounting for the effects of double
reduction and partial preferential pairing.
}
\section{Models}{


If \code{type = "polysomic"}, then the gamete frequencies correspond
to those of Huang et al (2019). Those formulas are for general multiallelic
loci, so see also Appendix G of Gerard (2022) for special case of
biallelic loci. The relevant parameter is \code{alpha}, a vector of
length \code{floor(ploidy / 4)}, where \code{alpha[[i]]} is the
probability that there are \code{i} pairs of double reduced alleles
in a gamete. The theoretical upper bound on \code{alpha} is given in
\code{\link{drbounds}()}.

If \code{type = "mix"} and \code{add_dr = FALSE}, then the gamete
frequencies correspond to the pairing configuration model of
Gerard et al (2018). This model states that the gamete frequencies are
a convex combination of the disomic inheritance frequencies. The weights
of this convex combination are provided in the \code{gamma} parameter. The
total number of disomic segregation patterns is given by
\code{\link{n_pp_mix}()}. The order of these segregation patterns used is
the order in \code{\link{seg}}.

The model for \code{type = "mix"} and \code{add_dr = TRUE} is the same
as for \code{type = "mix"} and \code{add_dr = FALSE} \emph{except} at
parental simplex loci. At such loci, there are no effects of preferential
pairing, and so the option \code{add_dr = TRUE} allows for the effects
of double reduction at simplex loci. The relevant parameter here is
\code{beta}. The first three gamete frequencies at simplex loci are
\code{c(0.5 + beta, 0.5 - 2 * beta, beta)}, and the rest are 0. The
upper bound on beta for two different models are given by
\code{\link{beta_bounds}()}.
}

\examples{
## Various duplex models
gamfreq(g = 2, ploidy = 4, gamma = c(0, 1), type = "mix")
gamfreq(g = 2, ploidy = 4, gamma = c(1, 0), type = "mix")
gamfreq(g = 2, ploidy = 4, gamma = c(0.5, 0.5), type = "mix")
gamfreq(g = 2, ploidy = 4, alpha = 0, type = "polysomic")
gamfreq(g = 2, ploidy = 4, alpha = 1/6, type = "polysomic")

## Various simplex models
gamfreq(g = 1, ploidy = 4, beta = 1/24, gamma = 1, type = "mix", add_dr = TRUE)
gamfreq(g = 1, ploidy = 4, alpha = 1/6, type = "polysomic")
gamfreq(g = 1, ploidy = 4, gamma = 1, type = "mix", add_dr = FALSE)
gamfreq(g = 1, ploidy = 4, alpha = 0, type = "polysomic")
}
\references{
\itemize{
\item{Gerard, D. (2023). Double reduction estimation and equilibrium tests in natural autopolyploid populations. \emph{Biometrics}, 79(3), 2143-2156. \doi{10.1111/biom.13722}}
\item{Gerard, D., Ferrão, L. F. V., Garcia, A. A. F., & Stephens, M. (2018). Genotyping polyploids from messy sequencing data. \emph{Genetics}, 210(3), 789-807. \doi{10.1534/genetics.118.301468}}
\item{Huang, K., Wang, T., Dunn, D. W., Zhang, P., Cao, X., Liu, R., & Li, B. (2019). Genotypic frequencies at equilibrium for polysomic inheritance under double-reduction. \emph{G3: Genes, Genomes, Genetics}, 9(5), 1693-1706. \doi{10.1534/g3.119.400132}}
}
}
\author{
David Gerard
}
