% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasonalize.R
\name{seasonalize}
\alias{seasonalize}
\title{Seasonalize a Deseasonalized Time Series}
\usage{
seasonalize(deseasonalized, indices, sl)
}
\arguments{
\item{deseasonalized}{A numeric vector or `ts` object of deseasonalized data.}

\item{indices}{A numeric vector (or data.frame column) of seasonal indices of length `sl`.}

\item{sl}{A positive integer giving the seasonal period.}
}
\value{
A data.frame with columns: Observation (index), Season (label), Deseasonalized (input), Seasonal_Index (from `indices`), Seasonalized (output).
}
\description{
Seasonalize a Deseasonalized Time Series
}
\examples{
data <- as.ts(rnorm(48, mean = 100, sd = 48), frequency = 12)
sl <- 12
si <- SI(data, sl)
deseasonalized <- deseasonalize(data, si$Seasonal_Index, sl)
seasonalized <- seasonalize(deseasonalized$Deseasonalized, si$Seasonal_Index, sl)
}
