% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{gen_repro_seed}
\alias{gen_repro_seed}
\title{Generate Reproducible Random Seed}
\usage{
gen_repro_seed(base_string = "searchAnalyzeR")
}
\arguments{
\item{base_string}{Base string for seed generation}
}
\value{
Integer seed value
}
\description{
Generate Reproducible Random Seed
}
\details{
This function generates a reproducible seed based on a string input.
It does not set the seed automatically - users should call set.seed()
themselves if they want to use the generated seed.
}
\examples{
# Generate a seed value
seed_value <- gen_repro_seed("my_analysis")

# User can choose to set it
\donttest{
set.seed(seed_value)
sample(1:10, 3)
}
}
