% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance-metrics.R
\name{find_top_terms}
\alias{find_top_terms}
\title{Find Top Performing Terms}
\usage{
find_top_terms(
  term_analysis,
  n = 3,
  score_col = "tes",
  plot = TRUE,
  plot_type = "precision_only"
)
}
\arguments{
\item{term_analysis}{Data frame from term_effectiveness() function}

\item{n}{Number of top terms to identify (default: 3)}

\item{score_col}{Name of the score column to use for ranking (default: "tes")}

\item{plot}{Whether to create a highlighted plot (default: TRUE)}

\item{plot_type}{Type of plot for highlighting ("precision_only", "coverage_only", "precision_coverage")}
}
\value{
List containing top terms and optionally a highlighted plot
}
\description{
Identifies the top-performing search terms based on their effectiveness scores
and optionally creates highlighted visualizations.
}
\details{
This function:
\enumerate{
\item Calculates effectiveness scores if not already present
\item Identifies the top N performing terms
\item Optionally creates a visualization highlighting these terms
}
}
