% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance-metrics.R
\name{calc_precision_recall}
\alias{calc_precision_recall}
\title{Calculate Precision and Recall Metrics}
\usage{
calc_precision_recall(retrieved, relevant, total_relevant = NULL)
}
\arguments{
\item{retrieved}{Vector of retrieved article IDs}

\item{relevant}{Vector of relevant article IDs (gold standard)}

\item{total_relevant}{Total number of relevant articles in corpus}
}
\description{
Calculate Precision and Recall Metrics
}
\details{
Calculates standard information retrieval metrics:
\itemize{
\item \strong{Precision}: TP/(TP+FP) - proportion of retrieved articles that are relevant
\item \strong{Recall}: TP/(TP+FN) - proportion of relevant articles that were retrieved
\item \strong{F1 Score}: Harmonic mean of precision and recall
\item \strong{Number Needed to Read}: 1/precision - articles needed to read to find one relevant
}
where TP = True Positives, FP = False Positives, FN = False Negatives
}
\examples{
retrieved_ids <- c("art1", "art2", "art3", "art4", "art5")
relevant_ids <- c("art1", "art3", "art6", "art7")
metrics <- calc_precision_recall(retrieved_ids, relevant_ids)
print(paste("Precision:", round(metrics$precision, 3)))
print(paste("Recall:", round(metrics$recall, 3)))
}
\references{
Manning, C. D., Raghavan, P., & Schütze, H. (2008). Introduction to information retrieval.
}
