% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtc_problems.R
\name{problems}
\alias{problems}
\title{Retrieve date/time parsing problems}
\usage{
problems(x = .Last.value)
}
\arguments{
\item{x}{An object of class iso8601, as typically obtained from a call to
\code{\link[=create_iso8601]{create_iso8601()}}. The argument can also be left empty, in that case
\code{problems()} will use the last returned value, making it convenient to use
immediately after \code{\link[=create_iso8601]{create_iso8601()}}.}
}
\value{
If there are no parsing problems in \code{x}, then the returned value is
\code{NULL}; otherwise, a \link[tibble:tibble-package]{tibble} of parsing failures
is returned. Each row corresponds to a parsing problem. There will be a
first column named \code{..i} indicating the position(s) in the inputs to the
\code{\link[=create_iso8601]{create_iso8601()}} call that resulted in failures; remaining columns
correspond to the original input values passed on to \code{\link[=create_iso8601]{create_iso8601()}},
with columns being automatically named \code{..var1}, \code{..var2}, and so on, if
the inputs to \code{\link[=create_iso8601]{create_iso8601()}} were unnamed, otherwise, the original
variable names are used instead.
}
\description{
\code{\link[=problems]{problems()}} is a companion helper function to \code{\link[=create_iso8601]{create_iso8601()}}. It
retrieves ISO 8601 parsing problems from an object of class iso8601, which is
\code{\link[=create_iso8601]{create_iso8601()}}'s return value and that might contain a \code{problems}
attribute in case of parsing failures. \code{\link[=problems]{problems()}} is a helper function that
provides easy access to these parsing problems.
}
\examples{
dates <-
  c(
    "2020-01-01",
    "2020-02-11",
    "2020-01-06",
    "2020-0921",
    "2020/10/30",
    "2020-12-05",
    "20231225"
  )

# By inspecting the problematic dates it can be understood that
# the `.format` parameter needs to updated to include other variations.
iso8601_dttm <- create_iso8601(dates, .format = "y-m-d")
problems(iso8601_dttm)

# Including more parsing formats addresses the previous problems
formats <- c("y-m-d", "y-md", "y/m/d", "ymd")
iso8601_dttm2 <- create_iso8601(dates, .format = list(formats))

# So now `problems()` returns `NULL` because there are no more parsing issues.
problems(iso8601_dttm2)

# If you pass named arguments when calling `create_iso8601()` then they will
# be used to create the problems object.
iso8601_dttm3 <- create_iso8601(date = dates, .format = "y-m-d")
problems(iso8601_dttm3)

}
