% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_mle.R
\name{sdl_control}
\alias{sdl_control}
\title{Optimization Control Parameters Passed to optim}
\usage{
sdl_control(
  method = "BFGS",
  maxit = 8000,
  hessian = FALSE,
  start = NULL,
  reltol = 1e-10,
  ...
)
}
\arguments{
\item{method}{the method to be used. See "Details" in \code{\link[stats]{optim}}. The default
method (\code{"BFGS"}) is a quasi-Newton method (also known as a variable metric algorithm),
specifically that published simultaneously in 1970 by Broyden, Fletcher, Goldfarb and Shanno.}

\item{maxit}{the maximum number of iterations of the algorithm. Defaults to \code{2000}.}

\item{hessian}{logical. Should a numerically differentiated Hessian matrix be returned?}

\item{start}{an optional vector with starting values for all parameters for fitting an SDL
regression model. It must be passed in the order: \code{(beta, gamma)}, where
\code{beta} and \code{gamma} are regression coefficients associated with the mean and dispersion
regression submodels, respectively.}

\item{reltol}{relative convergence tolerance. The algorithm stops if it is unable to reduce the
value by a factor of reltol * (abs(val) + reltol) at a step. Defaults to \code{1e-10}.}

\item{...}{further arguments to be passed to \code{\link[stats]{optim}}.}
}
\value{
A list with the arguments specified.
}
\description{
Optimization parameters passed to \code{\link[stats]{optim}} for the fit of an modified skew
    discrete Laplace (SDL) regression model via \code{\link{sdlrm}}. This function acts in the
    same spirit as \code{\link[betareg]{betareg.control}} from the \code{betareg} package. Its
    primary purpose is to gather all the optimization control arguments in a single function.
}
\examples{
# Data set: pss (for description run ?pss)
barplot(table(pss$difference), xlab = "PSS index difference", ylab = "Frequency")
boxplot(pss$difference ~ pss$group, xlab = "Group", ylab = "PSS index difference")

## Fit of the model using the Fisher information matrix to obtain the covariance
## matrix of the coefficients
fit1 <- sdlrm(difference ~ group, data = pss, xi = 1)

## Fit of the model using the numerical Hessian matrix provided by optim
fit2 <- sdlrm(difference ~ group, data = pss, xi = 1, hessian = TRUE)

## Compare the reported standard errors
summary(fit1)
summary(fit2)
}
\references{
Cribari-Neto, F., and Zeileis, A. (2010). Beta regression in R.
    \emph{Journal of statistical software}, 34, 1-24.
}
\author{
Rodrigo M. R. de Medeiros <\email{rodrigo.matheus@ufrn.br}>
}
