################################################################################
# --------------------------- check_numeric_vector --------------------------- #
################################################################################

test_that("check_numeric_vector accepts valid input", {
  x <- c(1, 2, 3)
  M <- matrix(1:3, ncol = 1)
  expect_identical(check_numeric_vector(x), x)
  expect_identical(check_numeric_vector(5), 5)
  expect_identical(check_numeric_vector(M), as.numeric(M))
  expect_identical(check_numeric_vector(t(M)), as.numeric(M))
})

test_that("check_numeric_vector rejects invalid input", {
  M <- matrix(1:4, nrow = 2, ncol = 2)
  v <- array(1:8, dim = c(2,2,2))
  expect_error(check_numeric_vector("a"), "must be a numeric vector.")
  expect_error(check_numeric_vector(list(1,2,3)), "must be a numeric vector.")
  expect_error(check_numeric_vector(M), "must be a numeric vector.")
  expect_error(check_numeric_vector(v), "must be a numeric vector.")
})

test_that("check_numeric_vector returns a numeric vector", {
  M <- matrix(1:3, ncol = 1)
  out <- check_numeric_vector(M)
  expect_true(is.numeric(out))
  expect_true(is.vector(out))
})

test_that("check_numeric_vector uses custom name in error message", {
  M <- matrix(1:4, nrow = 2)
  expect_error(check_numeric_vector(M, name = "CustomName"), "CustomName")
})

################################################################################
# --------------------------- check_integer_scalar --------------------------- #
################################################################################

test_that("check_integer_scalar accepts valid input", {
  expect_invisible(check_integer_scalar(1))
})

test_that("check_integer_scalar rejects invalid input", {
  expect_error(check_integer_scalar("a"), "must be a natural number.")
  expect_error(check_integer_scalar(list(1)), "must be a natural number.")
  expect_error(check_integer_scalar(1.5), "must be a natural number.")
  expect_error(check_integer_scalar(pi), "must be a natural number.")
  expect_error(check_integer_scalar(0), "must be a natural number.")
  expect_error(check_integer_scalar(-3), "must be a natural number.")
  expect_error(check_integer_scalar(c(1,2)), "must be a natural number.")
})

test_that("check_integer_scalar uses custom variable name in error message", {
  expect_error(check_integer_scalar(0, name = "CustomName"), "CustomName")
})

################################################################################
# ------------------------- check_significance_level ------------------------- #
################################################################################

test_that("check_significance_level accepts valid input", {
  expect_invisible(check_significance_level(0.05))
})

test_that("check_significance_level rejects invalid input", {
  expect_error(
    check_significance_level("a"), 
    "must be a number between 0 and 1."
  )
  expect_error(
    check_significance_level(list(1)), 
    "must be a number between 0 and 1."
  )
  expect_error(
    check_significance_level(1.5), 
    "must be a number between 0 and 1."
  )
  expect_error(
    check_significance_level(-3), 
    "must be a number between 0 and 1."
  )
  expect_error(
    check_significance_level(c(1,2)), 
    "must be a number between 0 and 1."
  )
})

test_that("check_significance_level uses custom variable name in error message", {
  expect_error(check_significance_level(2, name = "CustomName"), "CustomName")
})

################################################################################
# ------------------------- check_penalisation_order ------------------------- #
################################################################################

test_that("check_penalisation_order accepts valid input", {
  expect_invisible(check_penalisation_order(2))
})

test_that("check_penalisation_order rejects invalid input", {
  expect_error(
    check_penalisation_order(10), 
    "can only attain the values 1,2,3,4,5,6."
  )
})

test_that("check_penalisation_order uses custom variable name in error message", {
  expect_error(check_penalisation_order(0, name = "CustomName"), "CustomName")
})

################################################################################
# ------------------------------- check_method ------------------------------- #
################################################################################

test_that("check_method accepts valid input", {
  expect_invisible(check_method("GCV"))
})

test_that("check_method rejects invalid input", {
  expect_error(
    check_method(1.5), 
    "must be one of: GCV, GCV-oracle, ML, ML-oracle."
  )
  expect_error(
    check_method("a"), 
    "must be one of: GCV, GCV-oracle, ML, ML-oracle."
  )
})

test_that("check_method uses custom variable name in error message", {
  expect_error(check_method(0, namex = "CustomName"), "CustomName")
  expect_error(
    check_method("GCV-oracle", namex = "x", f = "a", namef = "CustomName"), 
    "CustomName"
  )
})
