% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_distribution.R
\name{fit_powerlaw}
\alias{fit_powerlaw}
\title{Function to build power law distribution to fit a theortical target histogram}
\usage{
fit_powerlaw(n = 100, alpha = 1.5, xmin, xmax)
}
\arguments{
\item{n}{The number of random variates (points) to generate (default 100).}

\item{alpha}{The exponent (alpha parameter) of the power-law distribution (default 1.5).}

\item{xmin}{The lower bound (minimum value) of the truncated distribution.}

\item{xmax}{The upper bound (maximum value) of the truncated distribution.}
}
\value{
A numeric vector of `n` random variates sampled from the truncated power-law distribution.
}
\description{
Generates random numbers that follow a truncated power-law distribution.
This function uses the inverse cumulative distribution function (CDF)
to sample from the specified power-law within given minimum and maximum bounds.
}
\examples{
# Generate 100 random numbers from a power-law distribution
# with alpha=2.5, xmin=10, xmax=1000
set.seed(123)
powerlaw_samples <- fit_powerlaw(n = 100, alpha = 2.5, xmin = 10, xmax = 1000)
# hist(powerlaw_samples, main = "Power-Law Distribution Samples")
}
