% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_distribution.R
\name{cleanse_duplicates}
\alias{cleanse_duplicates}
\title{Remove Duplicate Polygons from Candidate Set}
\usage{
cleanse_duplicates(candidates)
}
\arguments{
\item{candidates}{An \code{sf} object containing candidate polygons.}
}
\value{
An \code{sf} object with duplicate polygons removed.
The function also prints messages to the console indicating whether
duplicates were found and their indices.
}
\description{
This function checks a set of candidate polygons and removes duplicates
based on spatial equality. It iteratively removes duplicated polygons
until none remain.
}
\details{
Duplicates are detected using \code{sf::st_equals()}, which checks
for geometric equality between polygons.
The function continues removing duplicates until no further matches are found.
}
\examples{
library(sf)

# Create a simple sf object with duplicate polygons
poly1 <- st_polygon(list(rbind(c(0,0), c(1,0), c(1,1), c(0,1), c(0,0))))
poly2 <- st_polygon(list(rbind(c(0,0), c(1,0), c(1,1), c(0,1), c(0,0)))) # duplicate
poly3 <- st_polygon(list(rbind(c(2,2), c(3,2), c(3,3), c(2,3), c(2,2))))

candidates <- st_sf(geometry = st_sfc(poly1, poly2, poly3))

cleansed <- cleanse_duplicates(candidates)

}
\seealso{
\code{\link[sf]{st_equals}}
}
