% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bplm.R, R/print-export-bplm.R
\name{bplm}
\alias{bplm}
\alias{print.sc_bplm}
\alias{export.sc_bplm}
\title{Bayesian Piecewise Linear Model}
\usage{
bplm(
  data,
  dvar,
  pvar,
  mvar,
  model = c("W", "H-M", "B&L-B"),
  contrast_level = c("first", "preceding"),
  contrast_slope = c("first", "preceding"),
  trend = TRUE,
  level = TRUE,
  slope = TRUE,
  random_trend = FALSE,
  random_level = FALSE,
  random_slope = FALSE,
  fixed = NULL,
  random = NULL,
  update_fixed = NULL,
  ...
)

\method{print}{sc_bplm}(x, digits = 3, ...)

\method{export}{sc_bplm}(
  object,
  caption = NA,
  footnote = NA,
  filename = NA,
  round = 2,
  nice = TRUE,
  ...
)
}
\arguments{
\item{data}{A single-case data frame. See \code{\link[=scdf]{scdf()}} to learn about this
format.}

\item{dvar}{Character string with the name of the dependent variable.
Defaults to the attributes in the scdf file.}

\item{pvar}{Character string with the name of the phase variable. Defaults to
the attributes in the scdf file.}

\item{mvar}{Character string with the name of the measurement time variable.
Defaults to the attributes in the scdf file.}

\item{model}{Model used for calculating the dummy parameters (see Huitema &
McKean, 2000). Default is \code{model = "W"}. Possible values are: \code{"B&L-B"},
\code{"H-M"}, \code{"W"}, and deprecated \code{"JW"}.}

\item{contrast_level}{Either "first", "preceding" or a contrast matrix. If NA
contrast_level is a copy of contrast.}

\item{contrast_slope}{Either "first", "preceding" or a contrast matrix. If NA
contrast_level is a copy of contrast.}

\item{trend}{A logical indicating if a trend parameters is included in the
model.}

\item{level}{A logical indicating if a level parameters is included in the
model.}

\item{slope}{A logical indicating if a slope parameters is included in the
model.}

\item{random_trend}{If TRUE, includes a random trend effect.}

\item{random_level}{If TRUE, includes a random level effect.}

\item{random_slope}{If TRUE, includes a random slope effect.}

\item{fixed}{A formula that overwrites the automatically created fixed part
of the regression model that defaults to the standard piecewise regression
model. The parameter phase followed by the phase name (e.g., phaseB)
indicates the level effect of the corresponding phase. The parameter
'inter' followed by the phase name (e.g., interB) adresses the slope effect
based on the method provide in the model argument (e.g., "B&L-B"). The
formula can be changed for example to include further L1 or L2 variables
into the regression model.}

\item{random}{A formula that overwrites the automatically created random part
of the regression model.}

\item{update_fixed}{An easier way to change the fixed model part (e.g., \code{. ~ . + newvariable}).}

\item{...}{Further arguments passed to the mcmcglmm function.}

\item{x}{An object returned by \code{\link[=bplm]{bplm()}}}

\item{digits}{The minimum number of significant digits to be use.
If set to "auto" (default), values are predefined.}

\item{object}{An scdf or an object exported from a scan function.}

\item{caption}{Character string with table caption. If left NA (default) a
caption will be created based on the exported object.}

\item{footnote}{Character string with table footnote. If left NA (default) a
footnote will be created based on the exported object.}

\item{filename}{String containing the file name. If a filename is given the
output will be written to that file.}

\item{round}{Integer passed to the digits argument used to round values.}

\item{nice}{If set TRUE (default) output values are rounded and optimized for
publication tables.}
}
\value{
An object of class \code{sc_bplm}.\tabular{ll}{
    \tab  \cr
   \code{model} \tab List containing information about the applied model. \cr
   \code{N} \tab Number of single-cases. \cr
   \code{formula} \tab A list containing the fixed and the random formulas of the hplm model. \cr
   \code{mcmglmm} \tab Object of class MCMglmm. \cr
   \code{contrast} \tab List with contrast definitions. \cr
}
}
\description{
Computes a bayesian (hierarchical) piecewise linear model based on a Markov
chain Monte Carlo sampler.
}
\section{Functions}{
\itemize{
\item \code{print(sc_bplm)}: Print results

\item \code{export(sc_bplm)}: Export results as html table (see \code{\link[=export]{export()}})

}}
\examples{
# plm regression
bplm(example_A24)

# Multilevel plm regression with random intercept
bplm(exampleAB_50, nitt = 5000)

# Adding a random slope
bplm(exampleAB_50, random_level = TRUE, nitt = 5000)
}
\seealso{
Other regression functions: 
\code{\link{hplm}()},
\code{\link{mplm}()},
\code{\link{plm}()},
\code{\link{print.sc_ac}()},
\code{\link{print.sc_bctau}()},
\code{\link{trend}()}
}
\author{
Juergen Wilbert
}
\concept{regression functions}
