% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_estimate_number_clusters.R
\name{number_clusters}
\alias{number_clusters}
\title{Estimate the Number of Observational and Distributional Clusters}
\usage{
number_clusters(object, ...)
}
\arguments{
\item{object}{An object of class \code{SANvi} or \code{SANmcmc}, typically, the output of a call to \code{\link{fit_fiSAN}}, \code{\link{fit_fSAN}}, or \code{\link{fit_CAM}}.}

\item{...}{ignored.}
}
\value{
A data frame reporting the estimated number of observational (OC) and distributional (DC) clusters.
\itemize{
  \item For \code{SANvi}: a single-row data frame with the point estimates.
  \item For \code{SANmcmc}: a three-row data frame with the mean, median, and variance across MCMC samples.
}
}
\description{
Computes the estimated number of observational clusters (OC) and distributional clusters (DC) from a fitted SAN model object.

For variational inference (\code{SANvi} objects), the function returns point estimates based on posterior mode assignments.
For MCMC-based inference (\code{SANmcmc} objects), it returns the mean, median, and variance of the number of clusters across posterior samples.
}
\examples{
# Generate example data
set.seed(123)
y <- c(rnorm(60), rnorm(40, 5))
g <- rep(1:2, each = 50)

plot(density(y[g == 1]), xlim = c(-5, 10), main = "Group-specific density")
lines(density(y[g == 2]), col = 2)

# Fit fiSAN via MCMC
est_mcmc <- fit_fiSAN(y, g, est_method = "MCMC")
number_clusters(est_mcmc)

# Fit fiSAN via Variational Inference
est_vi <- fit_fiSAN(y, g, est_method = "VI")
number_clusters(est_vi)

}
