#' Launch the Shiny application samplex
#'
#' Opens the Shiny app included in the package.
#'
#' @return Nothing; launches the Shiny app.
#' @export
#' @examples
#' if (interactive()) samplex()
samplex <- function() {
  app_dir <- system.file('app', package = 'samplex')
  if (identical(app_dir, '') || !dir.exists(app_dir)) {
    stop('App folder not found in inst/app. Was the package installed correctly?', call. = FALSE)
  }
  shiny::runApp(app_dir, display.mode = 'normal')
}
