% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-statevar.R
\name{plot_statevar_ts}
\alias{plot_statevar_ts}
\alias{plot_statevar_hist}
\alias{plot_spawners}
\alias{plot_fitness}
\alias{plot_escapement}
\alias{plot_fishery}
\alias{plot_Kobe}
\title{Plot core output from salmonMSE}
\usage{
plot_statevar_ts(
  SMSE,
  var = "PNI",
  s = 1,
  figure = TRUE,
  xlab = "Projection Year",
  quant = FALSE,
  ylab = var,
  ylim,
  agg.fun = sum,
  ...
)

plot_statevar_hist(SMSE, var = "PNI", s = 1, y, figure = TRUE, xlab = var, ...)

plot_spawners(SMSE, s = 1, prop = TRUE, FUN = median, figure = TRUE, ylim)

plot_fitness(SMSE, s = 1, FUN = median, figure = TRUE, ylim)

plot_escapement(SMSE, s = 1, FUN = median, figure = TRUE, ylim)

plot_fishery(
  SMSE,
  s = 1,
  type = c("catch", "exploit", "harvest"),
  FUN = median,
  figure = TRUE,
  ylim,
  ylab,
  ...
)

plot_Kobe(
  SMSE,
  s = 1,
  FUN = median,
  figure = TRUE,
  xlim,
  ylim,
  xlab = expression(NOS/S[MSY]),
  ylab = expression(U/U[MSY]),
  type = c("T", "PT")
)
}
\arguments{
\item{SMSE}{Class \linkS4class{SMSE} object returned by \code{\link[=salmonMSE]{salmonMSE()}}}

\item{var}{Character. Slot for the state variable in \code{SMSE} object. See \code{slotNames(SMSE)} for options. Additional supported options are:
\code{"ESS"} (egg-smolt survival), \code{"pbrood"} (broodtake to escapement ratio), \code{"pNOSesc"} (NOS/natural escapement), \code{"pHOSesc"} (HOS/hatchery escapement),
\verb{Total Spawners} (NOS + HOS), \code{NOS/SMSY}, \code{S/SMSY}, and \code{NOS/Sgen}.}

\item{s}{Integer. Population index for multi-population model (e.g., \code{s = 1} is the first population in the model)}

\item{figure}{Logical, whether to generate a figure (set to FALSE if only using the function to return the data matrix)}

\item{xlab}{Character. Name of time variable for the figure}

\item{quant}{Logical, whether to plot individual simulations (FALSE) or the median with 95 percent confidence intervals (TRUE)}

\item{ylab}{Character. Name of the state variable for the figure}

\item{ylim}{Vector. Y-axis limits}

\item{agg.fun}{Function. Defines how to aggregate state variables that are reported by age. Typically, \code{sum} is used but \code{max} is also
possible for reporting apical exploitation rates.}

\item{...}{Additional arguments to base plot function}

\item{y}{Integer. Projection year for the state variable to plot the histogram. If missing, the last projection year is used.}

\item{prop}{Logical, whether to plot proportions or absolute numbers}

\item{FUN}{Summarizing function across simulations, typically \code{\link[=median]{median()}} or \code{\link[=mean]{mean()}}}

\item{type}{For \code{plot_Kobe}, the fishery state variable to plot. Whether to plot the exploitation rate for the terminal (T) or pre-terminal fishery (PT).}

\item{xlim}{Vector. X-axis limits}
}
\value{
Functions return the matrix of plotted values invisibly. Figure plotted from base graphics
}
\description{
Various functions that plot the state variables from salmonMSE projections:
\itemize{
\item \code{plot_statevar_ts()} produces a time series for all simulations, or with confidence intervals
\item \code{plot_statevar_hist()} produces a histogram across all simulations for a particular year
\item \code{plot_spawners()} produces a summary barplot of spawners, including NOS, HOS, and wild spawners
\item \code{plot_escapement()} produces a summary figure of the proportion of spawners and broodtake to escapement
\item \code{plot_fitness()} produces a summary figure of metrics (fitness, PNI, pHOS, and pWILD) related to hatchery production
\item \code{plot_fishery()} produces a summary figure of metrics related to the fishery, e.g., median catch, exploitation rate or harvest rate
}
}
\seealso{
\code{\link[=plot_decision_table]{plot_decision_table()}} \code{\link[=plot_LHG]{plot_LHG()}}
}
