% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-statevar.R
\name{plot_decision_table}
\alias{plot_decision_table}
\title{Decision table of performance metrics}
\usage{
plot_decision_table(x, y, z, title, xlab, ylab)
}
\arguments{
\item{x}{Atomic, vector of values for the x axis (same length as z). Will be converted to factors}

\item{y}{Atomic, vector of values for the y axis (same length as z). Will be converted to factors}

\item{z}{Numeric, vector of values for the performance metric}

\item{title}{Character, optional title of figure}

\item{xlab}{Character, optional x-axis label}

\item{ylab}{Character, optional y-axis label}
}
\value{
ggplot object
}
\description{
Generates a coloured table of a performance metric across two axes, which may be a population dynamics variable
(e.g., productivity) or a management action (e.g., hatchery production levels or harvest strategy).
See example at \url{https://docs.salmonmse.com/articles/decision-table.html}
}
\seealso{
\code{\link[=plot_statevar_ts]{plot_statevar_ts()}} \code{\link[=plot_tradeoff]{plot_tradeoff()}}
}
