% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sakura.R
\name{serial_config}
\alias{serial_config}
\title{Create Serialization Configuration}
\usage{
serial_config(class, sfunc, ufunc, vec = FALSE)
}
\arguments{
\item{class}{character string of the class of object custom serialization
functions are applied to, e.g. \sQuote{ArrowTabular} or
\sQuote{torch_tensor}.}

\item{sfunc}{a function that accepts a reference object inheriting from
\sQuote{class} (or a list of such objects) and returns a raw vector.}

\item{ufunc}{a function that accepts a raw vector and returns a reference
object (or list of such objects).}

\item{vec}{[default FALSE] whether or not the serialization functions are
vectorized. If FALSE, they should accept and return reference objects
individually e.g. \code{arrow::write_to_raw} and
\code{arrow::read_ipc_stream}. If TRUE, they should accept and return a
list of reference objects, e.g. \code{torch::torch_serialize} and
\code{torch::torch_load}.}
}
\value{
A pairlist comprising the configuration. This may be provided to the
  'hook' argument of \code{\link{serialize}} and \code{\link{unserialize}}.
}
\description{
Returns a serialization configuration for custom serialization and
unserialization of non-system reference objects, using the 'refhook' system
of R native serialization. This allows their use across different R sessions.
}
\examples{
serial_config("test_class", base::serialize, base::unserialize)

}
