% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.excel.saeTrafo.R, R/write.ods.saeTrafo.R
\name{write.excel}
\alias{write.excel}
\alias{write.ods}
\title{Exports an saeTrafo Object to an Excel file or OpenDocument Spreadsheet}
\usage{
write.excel(
  object,
  file = "excel_output.xlsx",
  MSE = FALSE,
  CV = FALSE,
  split = FALSE
)

write.ods(
  object,
  file = "ods_output.ods",
  MSE = FALSE,
  CV = FALSE,
  split = FALSE
)
}
\arguments{
\item{object}{an object of type "saeTrafo", representing point and MSE
estimates.}

\item{file}{path and filename of the spreadsheet to create. It should end on
.xlsx or .ods respectively.}

\item{MSE}{logical. If \code{TRUE}, the MSE of the saeTrafoObject is
exported.
Defaults to \code{FALSE}.}

\item{CV}{logical. If \code{TRUE}, the CV of the saeTrafoObject is exported.
Defaults to \code{FALSE}.}

\item{split}{logical. If \code{TRUE}, point estimates, MSE and CV are written
to different sheets in the Excel file. In \code{write.ods} \code{TRUE} will
result in different files for point estimates and their precision.
Defaults to \code{FALSE}.}
}
\value{
An Excel file is created in your working directory, or at the given
path. Alternatively multiple ODS files are created at the given path.
}
\description{
Function \code{write.excel} enables the user to export point and MSE
estimates as well as diagnostics from the \code{summary} to an Excel file.
The user can choose if the results should be reported in one or several Excel
sheets. Furthermore, a selection of indicators can be specified.
Respectively the function \code{write.ods} enables the export to OpenDocument
Spreadsheets. Note that while \code{write.exel} will create a single document
\code{write.ods} will create a group of files.
}
\details{
These functions create an Excel file via the package
\pkg{\link[openxlsx]{openxlsx}} and ODS files via the package \pkg{readODS}.
Both packages require a zip application to be available to \R. If this is not
the case the authors of \pkg{\link[openxlsx]{openxlsx}} suggest the first of the
following two ways.
\itemize{
\item Install Rtools from: http://cran.r-project.org/bin/windows/Rtools/ and
modify the system PATH during installation.
\item If Rtools is installed, but no system path variable is set. One can
set such a variable temporarily to \R by a command like:
\code{Sys.setenv("R_ZIPCMD" = "PathToTheRToolsFolder/bin/zip.exe")}.
}
To check if a zip application is available they recommend the command
\code{shell("zip")}.
}
\examples{
# Examples for exporting saeTrafoObject to an Excel file or OpenDocument
# Spreadsheet

\dontrun{
# Load Data
data("eusilcA_smp")
data("pop_area_size")
data("pop_mean")
data("pop_cov")

# Nested error regression model
NER_model <- NER_Trafo(fixed = eqIncome ~ gender + eqsize + cash +
                       self_empl + unempl_ben + age_ben + surv_ben +
                       sick_ben + dis_ben + rent + fam_allow + house_allow +
                       cap_inv + tax_adj,
                       smp_domains = "district",
                       pop_area_size = pop_area_size,
                       pop_mean = pop_mean, pop_cov = pop_cov,
                       smp_data = eusilcA_smp, MSE = TRUE)

# Example 1: Export estimates for all indicators and uncertainty measures and
# diagnostics to Excel
write.excel(NER_model, file = "excel_output.xlsx", MSE = TRUE, CV = TRUE)

# Example 2: Single Excel sheets for point, MSE and CV estimates
write.excel(NER_model, file = "excel_output_split.xlsx", MSE = TRUE,
            CV = TRUE, split = TRUE)

# Example 3: Same as example 1 but for an ODS output
write.ods(NER_model, file = "ods_output_all.ods", MSE = TRUE, CV = TRUE)
}

}
\seealso{
\code{\link{saeTrafoObject}}, \code{\link{NER_Trafo}}
}
