% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_helpers.R
\name{admin_to_num}
\alias{admin_to_num}
\title{Convert Administrative Level String to Numeric Code}
\usage{
admin_to_num(admin_level)
}
\arguments{
\item{admin_level}{A character string representing the administrative level.
It can be "National" or "Admin-X" (where X is a positive integer).}
}
\value{
An integer representing the numerical level:
- "National" is converted to 0.
- "Admin-X" is converted to X as an integer.
- Returns NULL if the input is invalid.
}
\description{
This function converts administrative level names (e.g., "National", "Admin-1")
into corresponding numerical values.
}
\examples{
admin_to_num("National")   # Returns 0
admin_to_num("Admin-1")    # Returns 1
admin_to_num("Admin-2")    # Returns 2
admin_to_num("Invalid")    # Returns NULL
}
