% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dw_crude_mx.R
\name{dw_crude_mx}
\alias{dw_crude_mx}
\title{Computes crude/raw death rates/probabilities using double rolling windows}
\usage{
dw_crude_mx(
  exposed,
  deaths,
  age.window = 2,
  time.window = 2,
  age.wb = age.window,
  age.wf = age.window,
  time.wb = time.window,
  time.wf = time.window,
  weights = 1,
  initial = FALSE,
  partial = FALSE
)
}
\arguments{
\item{exposed}{A matrix (or data frame) of order nxT (where n is the number of ages and T the number of years), with ages by rows and years by columns (with no column for ages). For each age-year combination, the matrix contains either the initial number of individuals exposed to risk in the portfolio (population) or the time of exposition to risk of the exposed in the portfolio (population). By default, the matrix contains time exposures. When `exposed` contains initial number of individuals exposed to risk, time exposures are estimated assuming uniformity and a closed demographic system. It is assumed that the order of rows and columns in `deaths` and `exposed` is consistent  (i.e., identical), and that both ages and years are sequential.}

\item{deaths}{A matrix (or data frame) of order nxT, with ages by rows and years by columns (with no column for ages), containing the number of deaths recorded in the portfolio (population), where n is the number of ages and T the number of years. It is assumed that the order of rows and columns in `deaths` and `exposed` is consistent (i.e., are the same), and that both ages and years are sequential.}

\item{age.window}{An non-negative integer indicating the number of preceding and succeeding ages to be included in the age rolling window. Default, 2.}

\item{time.window}{An non-negative integer indicating the number of preceding and succeeding years (time periods) to be included in the year rolling window. Default, 2.}

\item{age.wb}{An non-negative integer indicating the number of preceding ages to be included in the age rolling window. Default, `age.window`.  If `age.wb` and `age.window` differ, the definition of `age.wb` takes precedence, allowing non-centered age windows.}

\item{age.wf}{An non-negative integer indicating the number of succeeding ages to be included in the age rolling window. Default, `age.window`. If `age.wf` and `age.window` differ, the definition of `age.wf` takes precedence, allowing non-centered age windows.}

\item{time.wb}{An non-negative integer indicating the number of preceding years to be included in the year rolling window. Default, `time.window`.  If `time.wb` and `time.window` differ, the definition of `time.wb` takes precedence, allowing non-centered time windows.}

\item{time.wf}{An non-negative integer indicating the number of succeeding years to be included in the year rolling window. Default, `time.window`. If `time.wf` and `time.window` differ, the definition of `time.wf` takes precedence, allowing non-centered time windows.}

\item{weights}{A matrix of order (age.wb + age.wf + 1) x (time.wb + time.wf + 1) of real positive numbers indicating the multiplicative factors to be applied to the different components of the double rolling window. Default, `1`; meaning all the components of the rolling window are aggregated as available in `exposed` and `deaths`.}

\item{initial}{A TRUE/FALSE argument indicating whether the numbers in `exposed` represent the initial number of individuals exposed to risk in the portfolio (population), which corresponds to `initial = TRUE`, or the time exposed to risk, with `initial = FALSE` as default.}

\item{partial}{A TRUE/FALSE argument indicating whether estimates obtained using incomplete rolling windows should be also computed. Default, `FALSE`; meaning crude death rates are estimated only for combinations of (year, age) where the corresponding double rolling window is complete.}
}
\value{
A list with six matrices: `mx`, `qx`, `Lx`, `dx`, `Lx.total`, `dx.total`. When `partial = FALSE` these matrices are of order (n - age.wb - age.wf) x (T - time.wb - time.wf); otherwise, they are of order nxT. The names of the rows and of the columns of these matrices are inherited from the corresponding names in the `deaths` object, ensuring that if the row names indicate ages and the column names indicate years, this contextual information is preserved.
 \item{mx}{ The `mx` matrix holds the crude death rates estimated after determining the number of individuals (time) exposed to risk and deaths to be used for each estimate using the specified rolling windows with the defined `weights`. }
 \item{qx}{ The `qx` matrix contains the raw death probabilities, derived from `mx`, based on the assumption that, on average, each deceased individual lives for half a year in the year of their death. }
 \item{Lx}{ The `Lx` matrix contains the actual time exposures used to compute the estimates. }
 \item{dx}{ The `dx` matrix contains the number of deaths used to compute the estimates.. }
 \item{Lx.total}{ The `Lx.total` matrix contains the total numbers for time exposures which corresponds to all factor-weights being equal. If `weights` is a constant matrix `Lx` and `Lx.total` coincide. }
 \item{dx.total}{ The `dx.total` matrix contains the total numbers deaths which corresponds to all factor-weights being equal. If `weights` is a constant matrix `dx` and `dx.total` coincide. }
}
\description{
This function estimates (crude/raw) death rates/probabilities using
             rolling windows in two dimensions (usually, age and time) from a
             given experience of mortality, summarized in a dataset of (either initial
             or times of) exposed to risk and a dataset of recorded deaths.
}
\note{
The function could be used to apply double rolling windows to datasets from other fields other than demography and actuarial science.
}
\examples{

exposed <- structure(list(Year2017 = c(6078.14, 5841.78, 5575.70, 5726.18, 5458.21, 5197.56,
                                    5018.12, 4791.56, 4245.15, 4321.65, 4179.3),
                          Year2018 = c(5978.73, 5473.78, 5572.23, 5495.19, 5148.47, 4845.14,
                                    4739.54, 4222.01, 4476.99, 4306.45, 4108.58),
                          Year2019 = c(5593.23, 5551.41, 5260.44, 5079.56, 4873.37, 4857.78,
                                    4536.12, 4453.85, 4310.89, 4015.02, 3974.25)),
                           class = "data.frame", row.names = 68:78)

deaths <- structure(list(Year2017 = c(144, 102, 113, 122, 156, 110, 126, 132, 120, 172, 110),
                          Year2018 = c(111, 122, 109, 116, 162, 154, 115, 146, 100, 169, 146),
                           Year2019 = c(100, 123, 113, 151, 122, 110, 137, 175, 137, 110, 155)),
                         class = "data.frame", row.names = 68:78)

example <- dw_crude_mx(exposed = exposed, deaths = deaths,
                       age.window = 2, time.window = 1, initial = FALSE)

}
\author{
Jose M. Pavia \email{pavia@uv.es}

Josep Lledo \email{josep.lledo@uv.es}
}
