% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{load_player_info}
\alias{load_player_info}
\title{Load cleaned player info from the volleydata repository.}
\usage{
load_player_info(league = NULL, seasons = NULL)
}
\arguments{
\item{league}{A string specifying which of "mlv", "lovb", or "au" to load data for.}

\item{seasons}{An integer or vector of integers of seasons to fetch data for. Defaults to all available seasons.}
}
\value{
A data frame containing the player info data for the specified seasons.\tabular{ll}{
   Column Name \tab Type \cr
   match_id \tab int \cr
   season \tab int \cr
   match_datetime \tab chr \cr
   player_id \tab int \cr
   player_name \tab chr \cr
   first_name \tab chr \cr
   last_name \tab chr \cr
   jersey_number \tab int \cr
   primary_position \tab int \cr
   roster_status \tab chr \cr
   is_foreign \tab lgl \cr
   is_confederation \tab lgl \cr
   is_captain \tab lgl \cr
   is_libero \tab lgl \cr
   set_1_is_starter \tab lgl \cr
   set_1_starting_position \tab int \cr
   set_2_is_starter \tab lgl \cr
   set_2_starting_position \tab int \cr
   set_3_is_starter \tab lgl \cr
   set_3_starting_position \tab int \cr
   set_4_is_starter \tab lgl \cr
   set_4_starting_position \tab int \cr
   set_5_is_starter \tab lgl \cr
   set_5_starting_position \tab int \cr
   team_name \tab chr \cr
   team_short_name \tab chr \cr
   team_code \tab chr \cr
   team_color \tab chr \cr
   league \tab chr \cr
}
}
\description{
Load cleaned player info from the volleydata repository.
}
\examples{
try({load_player_info("mlv", 2024)})
}
