% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiffFullScan.R
\name{getFullScanData}
\alias{getFullScanData}
\title{Extract raw Wiff full scan data}
\usage{
getFullScanData(scanfile, tic, sample, removeZeros = FALSE)
}
\arguments{
\item{scanfile}{A file path to a Sciex raw scan file (extension .wiff.scan)
containing the raw data referenced by the .wiff file from which the other
parameters were extracted}

\item{tic}{A (possibly partial) total ion chromatogram of the format output
by \code{\link[=getTIC]{getTIC()}} or \code{\link[=getAllTIC]{getAllTIC()}} referring to the range of timepoints to be
extracted}

\item{sample}{The particular object from the \code{samples} field of the
\code{rtmsWiffReader} object, which in this case contains binary offsets into the
.wiff.scan file}

\item{removeZeros}{If \code{FALSE} (the default) all intensity measuremens for
all time points and m/z values will be extractd and returned; if \code{TRUE},
only values greater than zero will be returned; this can result in a much
smaller output and may be useful for calculating areas}
}
\value{
A data frame containing all raw data for the given range (see
Details)
}
\description{
Extract raw Wiff full scan data
}
\details{
The data frame output by the function contains all the intensity data
compressed into the .wiff.scan file for the given range of times; it has the
following columns:
\itemize{
\item \code{index}: The particular row of \code{ptic} the measurement corresponds to
\item \code{time}: The time (in seconds) after the beginning of the run at which the
measurement was taken
\item \code{mz}: The mass to charge value (in m/z) which the measurement corresponds
to
\item \code{intensity}: The intensity (in counts per second) that was measured for
the given time and m/z value
}
}
