% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00tabletrees.R
\docType{class}
\name{LabelRow}
\alias{LabelRow}
\alias{DataRow-class}
\alias{ContentRow-class}
\alias{LabelRow-class}
\alias{.tablerow}
\alias{DataRow}
\alias{ContentRow}
\title{Row classes and constructors}
\usage{
LabelRow(
  lev = 1L,
  label = "",
  name = label,
  vis = !is.na(label) && nzchar(label),
  cinfo = EmptyColInfo,
  indent_mod = 0L,
  table_inset = 0L,
  trailing_section_div = NA_character_,
  round_type = valid_round_type
)

.tablerow(
  vals = list(),
  name = "",
  lev = 1L,
  label = name,
  cspan = rep(1L, length(vals)),
  cinfo = EmptyColInfo,
  var = NA_character_,
  format = NULL,
  na_str = NA_character_,
  klass,
  indent_mod = 0L,
  footnotes = list(),
  table_inset = 0L,
  trailing_section_div = NA_character_,
  round_type = valid_round_type
)

DataRow(...)

ContentRow(...)
}
\arguments{
\item{lev}{(\code{integer(1)})\cr nesting level (roughly, indentation level in practical terms).}

\item{label}{(\code{string})\cr a label (not to be confused with the name) for the object/structure.}

\item{name}{(\code{string})\cr name of the split/table/row being created. Defaults to the value of the
corresponding label, but is not required to be.}

\item{vis}{(\code{flag})\cr whether the row should be visible (\code{LabelRow} only).}

\item{cinfo}{(\code{InstantiatedColumnInfo} or \code{NULL})\cr column structure for the object being created.}

\item{indent_mod}{(\code{numeric})\cr modifier for the default indent position for the structure created by this
function (subtable, content table, or row) \emph{and all of that structure's children}. Defaults to 0, which
corresponds to the unmodified default behavior.}

\item{table_inset}{(\code{numeric(1)})\cr number of spaces to inset the table header, table body, referential footnotes,
and main footer, as compared to alignment of title, subtitles, and provenance footer. Defaults to 0 (no inset).}

\item{trailing_section_div}{(\code{string})\cr string which will be used as a section divider after the printing
of the last row contained in this (sub)table, unless that row is also the last table row to be printed overall,
or \code{NA_character_} for none (the default). When generated via layouting, this would correspond to the
\code{section_div} of the split under which this table represents a single facet.}

\item{round_type}{(\code{"iec"}, \code{"iec_mod"} or \code{"sas"})\cr the type of rounding to perform.
See \code{\link[formatters:round_fmt]{formatters::round_fmt()}} for details.}

\item{vals}{(\code{list})\cr cell values for the row.}

\item{cspan}{(\code{integer})\cr column span. \code{1} indicates no spanning.}

\item{var}{(\code{string})\cr variable name.}

\item{format}{(\code{string}, \code{function}, or \code{list})\cr format associated with this split. Formats can be declared via
strings (\code{"xx.x"}) or function. In cases such as \code{analyze} calls, they can be character vectors or lists of
functions. See \code{\link[formatters:list_formats]{formatters::list_valid_format_labels()}} for a list of all available format strings.}

\item{na_str}{(\code{string})\cr string that should be displayed when the value of \code{x} is missing. Defaults to \code{"NA"}.}

\item{klass}{(\code{character})\cr internal detail.}

\item{footnotes}{(\code{list} or \code{NULL})\cr referential footnotes to be applied at current level. In post-processing,
this can be achieved with \code{\link{fnotes_at_path<-}}.}

\item{...}{additional parameters passed to shared constructor (\code{.tablerow}).}
}
\value{
A formal object representing a table row of the constructed type.
}
\description{
Row classes and constructors

Row constructors and classes
}
\author{
Gabriel Becker
}
