% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addins.R
\name{addins}
\alias{addins}
\alias{str_addin}
\alias{head_addin}
\alias{tail_addin}
\alias{View_addin}
\alias{funSource_addin}
\alias{summary_addin}
\alias{dim_addin}
\alias{class_addin}
\alias{plot_addin}
\alias{hist_addin}
\alias{unique_addin}
\title{Rstudio keyboard shortcuts on F-keys}
\usage{
str_addin(
  obj = selectobject(),
  use_glimpse = getOption("rskey_glimpse", FALSE)
)

head_addin(obj = selectobject())

tail_addin(obj = selectobject())

View_addin(obj = selectobject())

funSource_addin(obj = selectobject(eval = FALSE))

summary_addin(obj = selectobject())

dim_addin(obj = selectobject())

class_addin(obj = selectobject())

plot_addin(obj = selectobject())

hist_addin(obj = selectobject())

unique_addin(obj = selectobject())
}
\arguments{
\item{obj}{List containing \code{object} (some R object) \code{fullcode}
(code, objectname, expression) and \code{code} 
(potentially truncated version).
For funSource_addin, only the function name should be highlighted.
DEFAULT: Rstudio addin selected code from \code{\link{selectobject}}}

\item{use_glimpse}{Logical: use \code{pillar::\link[pillar]{glimpse}} instead of
\code{base::\link{str}}? Can be set to TRUE with 
\code{options(rskey_glimpse=TRUE)}. To set permananently, use:
\code{cat("options(rskey_glimpse=TRUE)\n", file="~/.Rprofile", append=TRUE)}.
DEFAULT: getOption("rskey_glimpse", FALSE)}
}
\value{
Output of the respective functions
}
\description{
Rstudio addins to examine highlighted code / object.
It can be very useful to bind these addins as outlined in 
\url{https://github.com/brry/rskey#rstudio-addins-for-keyboard-shortcuts}
}
\examples{
# Go to Addins - browse Addins - Keyboard shortcuts - map commands as desired
# or use    setKeyboardBindings()

# highlight objects or code (examples below), then press keyboard shortcut
iris
iris$Sepal.Length + 10

}
\seealso{
\code{\link{selectobject}}, 
         \code{berryFunctions::\link[berryFunctions]{funSource}},
         \url{https://github.com/daattali/addinslist#readme}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, May 2017
}
