% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{ss.options}
\alias{ss.options}
\title{Set or reset parameters to be used by SaTScan}
\usage{
ss.options(invals = NULL, reset = FALSE, version = NULL)
}
\arguments{
\item{invals}{A list with entries of the form name=value, where value should be
in quotes unless it is a number. Alternatively, may be a character vector whose
entries are of the form "name=value".  The "name" in either case should be a
valid SaTScan parameter name; unrecognized names will generate a warning and will
do nothing.}

\item{reset}{If TRUE, will restore the default parameter values described in
the "Details" section.}

\item{version}{A string of the form "#.#" or "#.#.#" specifying a SaTScan
parameter set. If this parameter is NULL or not specified, then parameters
are reset based on the latest version of SaTScan.}
}
\value{
If \code{invals == NULL}, returns the current parameter set, as altered
by previous calls to \code{ss.options()} since the last call with \code{reset=TRUE}.
Otherwise returns modified parameter set invisibly. The side effect, if
\code{invals != NULL}, is to set the current values of the parameters per the
value of \code{invals} and \code{reset}.
}
\description{
Set or reset parameters used by SaTScan using the built-in
rsatscan parameter list. Some parameters must be specified using the
ss.options.extra() function.

Refer to the SaTScan parameter file after generating it from the SaTScan
GUI. The parameter file can be viewed in a text editor.
}
\details{
\code{ss.options()} is intended to function like \code{par()} or
\code{options()}.  There is a default set of parameter settings that resembles
the one used by SaTScan, except that it produces all possible output files and
makes them as .dbf files instead of text.
}
\section{SaTScan Versions}{

The \code{version} argument defines which parameter set the script uses,
not necessarily the version of SaTScan being used to execute the analyses.
SaTScan is backwards compatible with older versions of parameter sets.
For instance you might create a script that uses the 10.1 parameter set.
That parameter set in the script will continue to work as you upgrade your SaTScan
executable to newer versions. This is the same way that rsatscan worked up to version 1.0.3
where the script was locked to the 9.2 parameter set but you still could use SaTScan 9.3,
9.4, 9.7, 10.1, etc without access to the newer parameter set options introduced in
those versions. As such, users with scripts created with rsatscan prior to version 1.0.4
must explicitly set the parameter set version in their scripts.
}

\section{Environment Objects}{

The parameter sets are stored in the 'ssenv' environment object.

WARNING: Clearing your R environment will delete the 'ssenv' object and cause an error
when attempting to use any SaTScan parameter sets. The 'rsatscan' library must
be reloaded to restore the 'ssenv' object and allow SaTScan parameters to work
correctly.
}

\examples{
\dontrun{
head(ss.options(),3)
ss.options(list(CaseFile="NYCfever.cas"))
head(ss.options(),3)

# reset; shows whole parameter file without invisible()
invisible(ss.options(reset=TRUE))
head(ss.options(),3)

# Explicitly specifying a parameter set
invisible(ss.options(reset=TRUE, version="9.2"))
head(ss.options(), 3)
}

}
