% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsatscan.R
\docType{package}
\name{rsatscan}
\alias{rsatscan-package}
\alias{rsatscan}
\title{Tools for Running the External 'SaTScan' Software using R Classes and Methods.}
\description{
The 'SaTScan'(TM) \url{https://www.satscan.org} software uses spatial and
space-time scan statistics to detect and evaluate spatial and space-time clusters.
With the 'rsatscan' package, you can run the external SaTScan software from
within R using R data formats. To successfully select appropriate parameter
settings within 'rsatscan', you must first learn 'SaTScan'.
}
\details{
The parameter files are constructed in R using the \code{ss.options} function and written
to the OS using the \code{write.ss.prm} function.  SaTScan is run using the \code{satscan}
function.  The \code{satscan} function returns a  \code{satscan-class} object that has a
slot for every possible file that SaTScan makes, plus one for the parameter file you used
to generate the output.

The package also includes  \code{write.???} functions which will write case, control,
geography, population, etc., files in the format expected by SaTScan, if you happen to have
them (or make them) in R and want to write them into the OS for SaTScan to use.

There are \code{summary} and \code{print} methods for \code{satscan-class}
objects.  There are also \code{plot} methods in the \code{sf} package, which
can be used if the \code{sf} package and \code{sf} packages are
installed and SaTScan generated a shapefile.

For a new analysis, always start with the SaTScan GUI to test parameter
settings, run an example analysis, etc. Once parameter settings are
finalized, open the parameter file in a text editor and use as a template for
defining each parameter in R syntax using the \code{ss.options()} or
\code{ss.options.extra()} function. For example, per R syntax, string values and
parameter names with special characters must be in quotes. See the
\code{ss.options} and \code{ss.options.extra} sections for more details.

Currently the package works with SaTScan >= 9.2 and has been tested on Windows 10.
Please contact the maintainer if you find success or trouble on other OSes.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://www.satscan.org}
}

}
\author{
\strong{Maintainer}: Scott Hostovich \email{HostovichS@imsweb.com}

Authors:
\itemize{
  \item Ken Kleinman \email{ken.kleinman@gmail.com}
}

Other contributors:
\itemize{
  \item Amer Moosa \email{MoosaA@imsweb.com} [contributor]
}

}
