% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/store.R
\name{rdf_load_file}
\alias{rdf_load_file}
\title{Load RDF from File}
\usage{
rdf_load_file(store, file, format = NULL, base_iri = NULL)
}
\arguments{
\item{store}{An RDF store handle}

\item{file}{Path to the RDF file}

\item{format}{RDF format. If NULL, guessed from file extension.}

\item{base_iri}{Optional base IRI for resolving relative URIs}
}
\value{
Invisibly returns NULL
}
\description{
Loads RDF data into the store from a file.
}
\examples{
store <- rdf_store()
# Create a temporary RDF file
tmp <- tempfile(fileext = ".nt")
writeLines('<http://example.org/s> <http://example.org/p> "value" .', tmp)
rdf_load_file(store, tmp)
rdf_size(store)
}
