% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/url.R
\name{osm_url_load_async}
\alias{osm_url_load_async}
\title{Load tile URLs}
\usage{
osm_url_load_async(tile, spec, callback = NULL, cache_spec = NULL)
}
\arguments{
\item{tile}{A `data.frame()` with columns `x`, `y`, and `zoom`.}

\item{spec}{An [osm_url_spec()]}

\item{callback}{A function to be run for each tile fetch or NULL
to do nothing. The callback is always called with two arguments: the first
is the subset of `tile` for which this URL applies (typically one row but
can be more than one in some corner cases); the second is the curl
response object whose useful elements are url, status_code, type, and
content.}

\item{cache_spec}{An optional [osm_url_spec()] or character vector to be
used as the cache.}
}
\value{
`tile`, invisibly.
}
\description{
Load tile URLs
}
\examples{
bounds <- wk::rct(
  252185, 4815826, 739729, 5210280,
  crs = "EPSG:32620"
)

tiles <- osm_tile_covering(bounds, zoom = 5)

osm_url_load_async(
  tiles,
  osm_url_spec_example(),
  function(tile, res) {
    str(tile)
    str(res)
  }
)

}
