% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{as.tile_source}
\alias{as.tile_source}
\alias{is.tile_source}
\alias{source_from_url_format}
\alias{register_tile_source}
\alias{set_default_tile_source}
\alias{get_default_tile_source}
\alias{osm.types}
\alias{bmaps.types}
\alias{bmaps.plot}
\alias{extract_bbox}
\alias{osm.plot}
\alias{osm.image}
\alias{osm.raster}
\alias{osm.points}
\alias{osm.segments}
\alias{osm.lines}
\alias{osm.polygon}
\alias{osm.text}
\alias{makebbox}
\alias{zoombbox}
\title{Deprecated interface}
\usage{
as.tile_source(x, ...)

is.tile_source(x)

source_from_url_format(
  url_format,
  max_zoom = tile.maxzoom.default(),
  min_zoom = 0,
  attribution = NULL,
  extension = tools::file_ext(url_format[1]),
  ...
)

register_tile_source(...)

set_default_tile_source(x, ...)

get_default_tile_source()

osm.types()

bmaps.types()

bmaps.plot(bbox, type = "Aerial", key = NULL, ...)

extract_bbox(x, tolatlon = TRUE, ...)

osm.plot(
  bbox,
  zoomin = 0,
  zoom = NULL,
  type = NULL,
  forcedownload = FALSE,
  stoponlargerequest = TRUE,
  fusetiles = TRUE,
  cachedir = NULL,
  res = 150,
  project = TRUE,
  progress = c("text", "none"),
  quiet = TRUE,
  ...
)

osm.image(
  x,
  zoomin = 0,
  zoom = NULL,
  type = NULL,
  forcedownload = FALSE,
  cachedir = NULL,
  progress = c("text", "none"),
  quiet = TRUE
)

osm.raster(
  x,
  zoomin = 0,
  zoom = NULL,
  type = "osm",
  forcedownload = FALSE,
  cachedir = NULL,
  progress = c("text", "none"),
  quiet = TRUE,
  projection = NULL,
  crop = FALSE,
  filename = NULL,
  resample = "bilinear",
  ...
)

osm.points(x, y = NULL, epsg = 4326, toepsg = 3857, ...)

osm.segments(x0, y0, x1 = x0, y1 = y0, epsg = 4326, toepsg = 3857, ...)

osm.lines(x, y = NULL, epsg = 4326, toepsg = 3857, ...)

osm.polygon(x, y = NULL, epsg = 4326, toepsg = 3857, ...)

osm.text(x, y = NULL, labels = seq_along(x), epsg = 4326, toepsg = 3857, ...)

makebbox(n, e, s, w)

zoombbox(bbox, factor = 1, offset = c(0, 0))
}
\arguments{
\item{x, y, x0, y0, x1, y1, url_format, max_zoom, min_zoom, attribution, extension}{Deprecated}

\item{...}{Arguments passed to other methods}

\item{bbox}{A bounding box as generated by \code{sp::bbox()}}

\item{type}{A map type; one of that returned by \link{osm.types}. User defined types are possible
by defining \code{tile.url.TYPENAME <- function(xtile, ytile, zoom){}} and passing TYPENAME
as the \code{type} argument.}

\item{key, tolatlon, epsg, toepsg, labels, n, e, s, w, factor, offset}{Deprecated}

\item{zoomin}{The amount by which to adjust the automatically calculated zoom (or
manually specified if the \code{zoom} parameter is passed). Use +1 to zoom in, or -1 to zoom out.}

\item{zoom}{Manually specify the zoom level (not reccomended; adjust \code{zoomin} or
\code{res} instead.}

\item{forcedownload}{\code{TRUE} if cached tiles should be re-downloaded. Useful if
some tiles are corrupted.}

\item{stoponlargerequest}{By default \code{osm.plot} will only load 32 tiles at a time. If
plotting at a higher resolution it may be necessary to pass \code{true} here.}

\item{fusetiles}{\code{TRUE} if tiles should be fused into a single image. This is the
default because white lines appear between tiles if it is set to \code{FALSE}. PDFs
appear not to have this problem, so when plotting large, high resolution PDFs it may be
faster (and more memory efficient) to use \code{fusetiles=FALSE}.}

\item{cachedir}{The directory in which tiles should be cached. Defaults to \code{getwd()/rosm.cache}.}

\item{res}{The resolution used to calculate scale.}

\item{project}{\code{TRUE} if tiles should be projected to a pseudo-mercator projection,
\code{FALSE} if lat/lon should be maintained. Becuase \code{sp::plot} adjusts the aspect
according to latitude for lat/lon coordinates, this makes little difference at high
zoom and may make plotting overlays more convenient. Defaults to \code{TRUE}.}

\item{progress}{A progress bar to use, or "none" to suppress progress updates}

\item{quiet}{Pass \code{FALSE} to see more error messages, particularly if
your tiles do not download/load properly.}

\item{projection}{A map projection in which to reproject the RasterStack as
generated by \code{CRS()} or \code{Spatial*@proj4string}. If a
\code{Spatial*} object is passed as the first argument, this argument will
be ignored.}

\item{crop}{\code{TRUE} if results should be cropped to the specified
bounding box (see \code{x}), \code{FALSE} otherwise.}

\item{filename}{A filename to which the raster should be written (see
\code{raster::writeRaster()}). Use a ".tif" extension to write as a
GeoTIFF.}

\item{resample}{One of "ngb" (nearest neighbour) or "bilinear". Passed to
\link[raster]{projectRaster}.}
}
\description{
The previous interface for rosm was written to support idioms that are
no longer prevalent in modren r-spatial code. These functions may continue
to exist; however, their use is not encouraged and the functions may be
removed in a future release.
}
