% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_generation.R
\name{pivot_schedule_longer}
\alias{pivot_schedule_longer}
\title{Pivot a rollout schedule from wide to long format with local time calculation}
\usage{
pivot_schedule_longer(
  schedule,
  time_cols,
  names_to = "chron_time",
  names_pattern = ".*(\\\\d+)",
  names_transform = as.numeric,
  values_to = "condition",
  values_transform = as.factor,
  cohort_name = "cohort",
  local_time = TRUE
)
}
\arguments{
\item{schedule}{A data frame containing the rollout schedule in wide format.}

\item{time_cols}{Columns containing time-specific condition assignments (tidyselect syntax).}

\item{names_to}{Name of the new column to store extracted chronological time (default \code{"chron_time"}).}

\item{names_pattern}{Regular expression to extract the numeric time from column names (default \code{".*(\\\\d+)"}).}

\item{names_transform}{Function to transform extracted time values (default \code{as.numeric}).}

\item{values_to}{Name of the new column to store condition values (default \code{"condition"}).}

\item{values_transform}{Function to transform condition values (default \code{as.factor}).}

\item{cohort_name}{The column indicating cohort membership for local time calculation (default \code{cohort}).}

\item{local_time}{Logical; if \code{TRUE}, adds a \code{local_time} column indicating time since rollout start for each cohort and condition (default \code{TRUE}).}
}
\value{
A long-format \code{tibble} with columns for cohort, condition, chronological time, and optionally local time.
}
\description{
Transforms a wide-format rollout schedule into a long-format schedule, extracting chronological time from column names,
converting condition columns to factors, and adding local time within each cohort if desired.
}
\examples{
library(dplyr)
library(tidyr)
schedule <- tibble::tibble(
  site = c("A", "B"),
  cohort = c(1, 2),
  t1 = c("control", "intervention"),
  t2 = c("intervention", "intervention")
)
pivot_schedule_longer(schedule, time_cols = starts_with("t"))
}
