% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_evaluation.R
\name{eval_less_than}
\alias{eval_less_than}
\title{Compute the proportion of values below term-specific thresholds within grouped simulation results}
\usage{
eval_less_than(x, term = NULL, na.rm = FALSE)
}
\arguments{
\item{x}{A numeric vector of estimates or statistics.}

\item{term}{A named numeric vector providing the threshold for each term.
For example, \code{c("(Intercept)" = 0, x = 2)}. If \code{NULL} (default), threshold is assumed to be zero.}

\item{na.rm}{Logical; whether to remove missing values when computing the proportion.
Defaults to \code{FALSE}.}
}
\value{
A numeric scalar representing the proportion of \code{x} below the term-specific threshold within the current group.
}
\description{
Computes the proportion of \code{x} values falling below term-specific thresholds within each group,
typically inside \code{evaluate_model_results()} for simulation evaluation pipelines.
}
\details{
This function is designed to be used inside \code{dplyr::summarise()} within a grouped
tidyverse pipeline, typically after grouping by \code{term}.

If \code{term} is provided, the current grouping must include a \code{term} variable matching
the names in \code{term}. If a term in the group is not found in the provided \code{term} mapping,
the function will return \code{NA} with a warning.
}
\examples{
library(dplyr)
library(purrr)
library(broom.mixed)

sim_models <- tibble(
  id = 1:50,
  model = map(1:50, ~ lm(mpg ~ wt, data = mtcars))
) |>
  extract_model_results()

sim_models |>
  filter(term == "wt") |>
  group_by(term) |>
  evaluate_model_results(
    prop_below_0 = eval_less_than(
      estimate,
      term = c("wt" = 0)
    )
  )

}
