% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_evaluation.R
\name{eval_bias}
\alias{eval_bias}
\title{Compute bias relative to term-specific true values within grouped simulation results}
\usage{
eval_bias(x, term = NULL, na.rm = FALSE, warnings = TRUE)
}
\arguments{
\item{x}{A numeric vector of estimates (e.g., from a model term).}

\item{term}{A named numeric vector providing the true value for each term.
For example, \code{c("(Intercept)" = 0, x = 2)} to specify the true values for each term.
If \code{NULL} (default), bias is computed relative to zero.}

\item{na.rm}{Logical; whether to remove missing values when computing the mean bias.
Defaults to \code{FALSE}.}

\item{warnings}{Should warnings be returned?}
}
\value{
A numeric scalar representing the mean bias within the current group.
}
\description{
Computes the mean bias (difference between estimated values and true values)
within each group, typically inside \code{evaluate_model_results()} for simulation evaluation pipelines.
}
\details{
This function is designed to be used inside \code{dplyr::summarise()} within a grouped
tidyverse pipeline, typically after grouping by \code{term}. It computes the mean of
\code{x} minus the true value for the corresponding term.

If \code{term} is provided, the current grouping must include a \code{term} variable matching
the names in \code{term}. If a term in the group is not found in the provided \code{term} mapping,
the function will return \code{NA} with a warning.
}
\examples{
library(dplyr)
library(purrr)
library(broom.mixed)

# Simulate and fit models
sim_models <- tibble(
  id = 1:50,
  model = map(1:50, ~ lm(mpg ~ wt, data = mtcars))
) |>
  extract_model_results()

# Compute bias relative to true value (hypothetical slope = -5)
sim_models |>
  filter(term == "wt") |>
  group_by(term) |>
  evaluate_model_results(
    bias = eval_bias(
      estimate,
      term = c("wt" = -5)
    )
  )

# Compute bias relative to zero for all terms
sim_models |>
  group_by(term) |>
  evaluate_model_results(
    bias = eval_bias(estimate)
  )

}
