% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_evaluation.R
\name{eval_between}
\alias{eval_between}
\title{Compute the proportion of values within term-specific intervals within grouped simulation results}
\usage{
eval_between(x, term = NULL, na.rm = FALSE)
}
\arguments{
\item{x}{A numeric vector of estimates or statistics.}

\item{term}{A named list of numeric vectors of length 2, giving the lower and upper bounds for each term.
For example, \code{list("(Intercept)" = c(-1, 1), x = c(1, 3))}.
If \code{NULL} (default), the interval is assumed to be \verb{[0, 1]}.}

\item{na.rm}{Logical; whether to remove missing values when computing the proportion.
Defaults to \code{FALSE}.}
}
\value{
A numeric scalar representing the proportion of \code{x} within the term-specific interval within the current group.
}
\description{
Computes the proportion of \code{x} values falling within term-specific intervals within each group,
typically inside \code{evaluate_model_results()} for simulation evaluation pipelines.
}
\details{
This function is designed to be used inside \code{dplyr::summarise()} within a grouped
tidyverse pipeline, typically after grouping by \code{term}.

If \code{term} is provided, the current grouping must include a \code{term} variable matching
the names in \code{term}. If a term in the group is not found in the provided \code{term} mapping,
the function will return \code{NA} with a warning.
}
\examples{
library(dplyr)
library(purrr)
library(broom.mixed)

sim_models <- tibble(
  id = 1:50,
  model = map(1:50, ~ lm(mpg ~ wt, data = mtcars))
) |>
  extract_model_results()

sim_models |>
  filter(term == "wt") |>
  group_by(term) |>
  evaluate_model_results(
    prop_between = eval_between(
      estimate,
      term = list("wt" = c(-1, 0))
    )
  )

}
