% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect_simulation.R
\name{add_error}
\alias{add_error}
\title{Add an error term for simulation}
\usage{
add_error(.data, variance = 1)
}
\arguments{
\item{.data}{A data frame to which the error term will be added.}

\item{variance}{Numeric; variance of the residual error (default \code{1}).}
}
\value{
A \code{tibble} with an added \code{.error} column.
}
\description{
Adds a residual error term (column \code{.error}) to the data frame, drawn from a normal distribution with specified variance.
}
\examples{
df <- tibble::tibble(x = 1:5)
add_error(df, variance = 2)
}
