% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flat_table_transform.R
\name{transform_attribute_format}
\alias{transform_attribute_format}
\alias{transform_attribute_format.flat_table}
\title{Transform attribute format}
\usage{
transform_attribute_format(
  ft,
  attributes,
  width,
  decimal_places,
  k_sep,
  decimal_sep,
  space_filling
)

\method{transform_attribute_format}{flat_table}(
  ft,
  attributes,
  width = 1,
  decimal_places = 0,
  k_sep = NULL,
  decimal_sep = NULL,
  space_filling = TRUE
)
}
\arguments{
\item{ft}{A \code{flat_table} object.}

\item{attributes}{A vector of strings, attribute names.}

\item{width}{An integer, string length.}

\item{decimal_places}{An integer, number of decimal places.}

\item{k_sep}{A character, thousands separator used (It can not be changed).}

\item{decimal_sep}{A character, decimal separator used (It can not be changed).}

\item{space_filling}{A boolean, fill on the left with spaces (with '0' otherwise).}
}
\value{
ft A \code{flat_table} object.
}
\description{
Transforms numeric attributes adapting their format as indicated.
}
\details{
If a number > 1 is specified in the \code{width} parameter, at least that length
will be obtained in the result, padded with blanks on the left.
}
\examples{

ft <- flat_table('iris', iris) |>
  transform_to_attribute(measures = "Sepal.Length", decimal_places = 2) |>
  transform_attribute_format(
    attributes = "Sepal.Length",
    width = 5,
    decimal_places = 1
  )

}
\seealso{
\code{\link{flat_table}}

Other flat table transformation functions: 
\code{\link{add_custom_column}()},
\code{\link{remove_instances_without_measures}()},
\code{\link{replace_empty_values}()},
\code{\link{replace_string}()},
\code{\link{replace_unknown_values}()},
\code{\link{select_attributes}()},
\code{\link{select_instances}()},
\code{\link{select_instances_by_comparison}()},
\code{\link{select_measures}()},
\code{\link{separate_measures}()},
\code{\link{transform_from_values}()},
\code{\link{transform_to_attribute}()},
\code{\link{transform_to_measure}()},
\code{\link{transform_to_values}()}
}
\concept{flat table transformation functions}
