% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classMethod_scenarios.r
\name{scenarios}
\alias{scenarios}
\title{Run a zero-dimensional model, possibly for multiple scenarios}
\arguments{
\item{times}{Numeric vector defining the times for which the future
state of the system is computed.}

\item{scenarios}{Either \code{NULL} or a named list, each element of which
defines a scenario to be considered. In the latter case, list elements must
be (named) numeric vectors used to update the initial values and parameters
provided as defaults in the workbook from which the model was imported.
The vectors for the individual scenarios can differ in length but their
length could also be consistent across scenarios.
If \code{scenarios} is set to \code{NULL}, only the
default scenario will be run. See details and examples.}

\item{fortran}{Logical. Passed to the respective argument of
\code{\link{dynamics}}.}

\item{plot.vars}{Logical. Plot the dynamics of all state variables?}

\item{plot.pros}{Logical. Plot the dynamics of process rates?}

\item{leg}{Keyword to set the position of the legend (if plots are created).}

\item{mar}{Numeric vector of length 4 to control figure margins. See the
\code{mar} tag of \code{\link[graphics]{par}}.}

\item{...}{Possible optional arguments passed to the numerical solver,
namely \code{\link[deSolve]{lsoda}}. Can be used, for example, to limit
the maximum step size through the \code{hmax} argument if boundary
vary on short time scales.}
}
\value{
A data frame with at least three columns and one row for each
  time requested via the \code{times} argument. The first column
  indicates the scenario, the second column holds the time, and further
  columns hold the values of state variables and process rates.
}
\description{
Triggers dynamic simulation(s) of a 0D model for one to many scenarios. The
individual scenarios can differ by the initial state or the values of
parameters. Optionally produces basic plots.
}
\note{
If the \code{scenarios} argument is used to update initial values and /
or parameters, the following applies: For each parameter not being included
  (by name) in the vector for a particular scenario, the default value
  will be used (as stored in the workbook from which the model was imported).
  The same is true for the initial values of variables. See the examples
  below.
}
\examples{

# build the model
m <- buildFromWorkbook(system.file("models/SEIR.xlsx", package="rodeo"))

# run with defaults
x <- m$scenarios(times=0:30, scenarios=NULL)

# run with updated values 
x <- m$scenarios(times=0:30,
  scenarios=list(default=c(t=1, i=0.2, r=0.4), fast=c(t=1, i=0.5, r=0.1))
)
}
\seealso{
Look at \code{\link{buildFromWorkbook}} for how to create a
  suitable model object.
}
\author{
David Kneis \email{david.kneis@tu-dresden.de}
}
