% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plainMethod_buildFromText.r
\name{buildFromText}
\alias{buildFromText}
\title{Build a model from the contents of delimited textfiles}
\usage{
buildFromText(
  declarations,
  equations,
  sep = "\\t",
  dim = 1,
  set_defaults = TRUE,
  fortran = FALSE,
  sources = NULL,
  ...
)
}
\arguments{
\item{declarations}{File path of a delimited text file holding the
declaration of state variables, parameters, and functions. See below for
details about the expected file contents.}

\item{equations}{File path of a delimited text file holding mathematical
expressions of process rates and stoichiometric factors forming the right
hand sides of a system of simultaneous ODE. See below for details about the
expected file contents.}

\item{sep}{The column delimiter used in the input text files.}

\item{dim}{The number of spatial compartments, possibly in multiple
dimensions. For single-box models without spatial resolution, use
\code{dim=1} (default). For a one-dimensional model with 10 compartments
use, e.g., \code{dim=10}. See the \code{dim} argument of the method
\code{\link[rodeo]{initialize}} for further details.}

\item{set_defaults}{If \code{TRUE}, parameters and initial values will be
set according to the contents of the 'default' columns of the workbook
sheets 'declarations', respectively. If \code{FALSE}, values must be
set explicitly using the class methods \code{\link[rodeo]{setPars}} and
\code{\link[rodeo]{setVars}}. An attempt to use \code{set_defaults=TRUE}
when \code{dim != 1} will be ignored (with a warning).}

\item{fortran}{Controls the language of code generation. The default
(\code{FALSE}) produces R code. Use \code{TRUE} if you want to use
compiled Fortran code for better performance. In the latter case, you will
need a Fortran compiler which is accessible by R.}

\item{sources}{Only relevant if \code{fortran=TRUE}. The argument
allows the name(s) of additional source file(s) to be provided
for processing by the Fortran compiler. In any case, the Fortran code
in \code{sources} must implement a module with the fixed name 'functions'.
This module must contain all user-defined functions referenced in any
process rate expressions or any cell of the stoichiometry matrix.}

\item{...}{Optional arguments passed to \code{\link{read.table}}.}
}
\value{
An object of class \code{\link[rodeo]{rodeo}}.
}
\description{
The function builds a \code{\link[rodeo]{rodeo}}-based model by importing
all declarations and equations from tables stored as delimited text.
}
\note{
The delimited text files provided as input are parsed by
  \code{\link{read.table}} with \code{header=TRUE} and the delimiter
  specified by \code{sep}. The files must contain the following:
\itemize{
  \item{'declarations'} Declares the identifiers of state variables,
    parameters, and functions used in the model equations. Mandatory columns
     are 'type', 'name', 'unit', 'description', and 'default'. Entries in
     the type column must be one of 'variable', 'parameter', or 'function'.
     If source code is generated for R (\code{fortran=FALSE}), any declared
     functions must be accessible in the environment where the model is
     run. If \code{fortran=TRUE}, the functions must be implemented in the
     file(s) listed in \code{sources} to be included in compilation.
     Entries in the 'name' column must be unique, valid identifier names
     (character followed by characters, digits, underscore).
     Entries in the 'default' column shall be numeric.
  \item{'equations'} Specifies the model equations. Mandatory columns
     are 'name', 'unit', 'description', 'rate' plus one column for
     every state variable of the model. The 'rate' columns holds math
     expressions for the process rates and columns named after state
     variables contain the corresponding expressions representing
     stoichiometric factors. All columns are of type character.
}
The best way to understand the contents of the input files is to study
the examples in the folder 'models' shipped with the package. Type
\code{system.file("models", package="rodeo")} at the R prompt to see
where this folder is installed on your system. A full example is given below.
}
\examples{

# Build and run a SEIR type epidemic model
decl <- system.file("models/SEIR_declarations.txt", package="rodeo")
eqns <- system.file("models/SEIR_equations.txt", package="rodeo")
m <- buildFromText(decl, eqns)
x <- m$dynamics(times=0:30, fortran=FALSE)
print(head(x))
}
\seealso{
\code{\link{buildFromWorkbook}} provides similar functionality
}
\author{
David Kneis \email{david.kneis@tu-dresden.de}
}
