% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_ROCKproject.R
\name{import_ROCKproject}
\alias{import_ROCKproject}
\title{Import a ROCK project from a ROCKproject file}
\usage{
import_ROCKproject(
  input,
  path = ".",
  createDirs = FALSE,
  preventOverwriting = TRUE,
  forceBaseZip = FALSE,
  silent = rock::opts$get(silent)
)
}
\arguments{
\item{input}{The path to the ROCK project file (typically with the extension \code{.ROCKproject})}

\item{path}{The path where to store the ROCK project}

\item{createDirs}{Whether to, if the \code{path} does not exist, create it}

\item{preventOverwriting}{If the path already contains files, whether to
prevent them from being overwritten (\code{TRUE}) or not (\code{FALSE}).}

\item{forceBaseZip}{Whether to force using the \code{zip()} function included in
R even if the \code{zip} package is installed.}

\item{silent}{Whether to be chatty or silent}
}
\value{
Invisibly, \code{output}.
}
\description{
Import a ROCK project from a ROCKproject file
}
\examples{
### Get path to example project
exampleProjectFile <-
  system.file(
    "ROCKprojects",
    "example1.ROCKproject",
    package="rock"
  );

### Get a temporary directory to write to
temporaryDir <-
  tempdir();

### Import the project
rock::import_ROCKproject(
  input = exampleProjectFile,
  path = temporaryDir,
  silent = FALSE
);
}
