% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_uids.R
\name{generate_uids}
\alias{generate_uids}
\title{Generate utterance identifiers (UIDs)}
\usage{
generate_uids(x, origin = Sys.time(), follow = NULL, followBy = NULL)
}
\arguments{
\item{x}{The number of identifiers to generate.}

\item{origin}{The origin to use when generating the actual
identifiers; see the \code{\link[squids:squids]{squids::squids()}} documentation.}

\item{follow}{A vector of one or more UIDs (or a list; lists are
recursively \code{unlist()}ed); the highest UID will be taken, converted
to a timestamp, and used as \code{origin} (well, 0.01 second later), so that the
new UIDs will follow that sequence.}

\item{followBy}{When following a vector of UIDs, this can be used to
specify the distance between the two vectors in centiseconds.}
}
\value{
A vector of UIDs.
}
\description{
This function generates utterance identifiers. Utterance identifiers are
Short Quasi-Unique Identifiers (SQUIDs) generated using
the \code{\link[squids:squids]{squids::squids()}} function.
}
\examples{
### Produce and store five UIDs
fiveUIDs <-
  rock::generate_uids(5);

### Look at them
fiveUIDs;

### Use a specific origin to be able to reproduce
### a set of UIDs later (e.g. in a script)
uidOrigin <-
  as.POSIXct("2025-05-21 21:53:25 CEST");

rock::generate_uids(
  5,
  origin = uidOrigin
);

### Produce five more UIDs to show
### their 'progression'
rock::generate_uids(5);

### Produce a set of five UIDs that follow
### the first set of five UIDs
rock::generate_uids(
  5,
  follow = fiveUIDs
);

### Follow with a 'distance' of 5 utterances
rock::generate_uids(
  5,
  follow = fiveUIDs,
  followBy = 5
);
}
