% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_fullyMergedCodeTrees.R
\name{export_fullyMergedCodeTrees}
\alias{export_fullyMergedCodeTrees}
\title{Export the fully merged code tree(s)}
\usage{
export_fullyMergedCodeTrees(x, file)
}
\arguments{
\item{x}{A parsed source(s) object.}

\item{file}{The file to save to.}
}
\value{
Invisibly, \code{NULL}.
}
\description{
Export the fully merged code tree(s)
}
\examples{
### Get path to example source
examplePath <-
  system.file("extdata", package="rock");

### Get a path to one example file
exampleFile <-
  file.path(examplePath, "example-1.rock");

### Load example source
loadedExample <- rock::parse_source(exampleFile);

tempFile <- tempfile(fileext = ".svg");

### Export merged code tree
export_fullyMergedCodeTrees(
  loadedExample,
  tempFile
);
}
