% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Aux-Functions.R
\name{set.link}
\alias{set.link}
\title{Link functions for robust beta regression}
\usage{
set.link(link.mu = "logit", link.phi = "log")
}
\arguments{
\item{link.mu}{character specifying the mean link function. Currently, the functions
"\code{logit}", "\code{probit}", "\code{cauchit}", "\code{cloglog}",
 and "\code{loglog}" are supported. Default is "\code{logit}".}

\item{link.phi}{character specifying the precision link function. Currently,
the functions "\code{log}", "\code{identity}", and "\code{sqrt}" are supported.
Default is "\code{log}".}
}
\value{
\code{set.link} provides the link function, inverse link function, first and
  second derivatives for both mean and precision submodels.
}
\description{
This function provides several link functions for robust beta regression.
}
\examples{
\donttest{
links = set.link(link.mu = "cauchit", link.phi = "sqrt")
attributes(links)}

}
