% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robustbetareg.R
\name{predict}
\alias{predict}
\title{Prediction Methods for robustbetareg Objects Class}
\usage{
predict(
  object,
  newdata = NULL,
  type = c("response", "link", "precision", "variance", "quantile"),
  at = 0.5,
  ...
)
}
\arguments{
\item{object}{fitted model object of class "\code{robustbetareg}".}

\item{newdata}{optional, a data frame with new predictor values. If omitted,
the original predictors are used.}

\item{type}{character indicating type of predictions: fitted means of response
("\code{response}"), corresponding linear predictor ("\code{link}"),
fitted precision parameter phi ("\code{precision}"), fitted variances
of response ("\code{variance}"), or fitted quantile(s) of the response
distribution ("\code{quantile}").}

\item{at}{numeric vector indicating the level(s) at which quantiles should be
predicted (only if \code{type = "quantile"}). Default is the median
\code{at = 0.5}.}

\item{...}{currently not used.}
}
\value{
Return a vector with the predicted values.
}
\description{
Extract various types of predictions from beta regression models: either on
the scale of responses in (0, 1) or the scale of the linear predictor,
from \code{robustbetareg} objects.
}
\examples{
\donttest{
get(data("HIC", package = "robustbetareg"))
hic <- robustbetareg(HIC ~ URB + GDP | 1, data = HIC, alpha = 0.04)
cbind(predict(hic, type = "response"), predict(hic, type = "quantile", at = c(0.25, 0.5, 0.75)))
}

}
