% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_statis_biplot_projection.R
\name{plot_statis_biplot_projection}
\alias{plot_statis_biplot_projection}
\title{HJ-Biplot Projection - Robust STATIS Dual (Phase 2)}
\usage{
plot_statis_biplot_projection(phase1_result, phase2_result, dims = c(1, 2))
}
\arguments{
\item{phase1_result}{Result from \code{robust_statis_phase1()}.}

\item{phase2_result}{Result from \code{robust_statis_phase2()} (must include \code{standardized_data},
\code{t2_stats_by_batch} and \code{threshold}).}

\item{dims}{Dimensions to plot (default: c(1, 2)).}
}
\value{
A ggplot2 object with the projected HJ-Biplot for Phase 2 batches.
}
\description{
Projects new batches from Phase 2 into the HJ-Biplot space defined by the robust compromise matrix
and eigen decomposition from Phase 1.
}
\details{
This implementation follows the HJ-Biplot formulation of Galindo-Villardón (1986).
The compromise matrix \eqn{C}, being symmetric and positive semidefinite, is
decomposed via an eigen decomposition (not a rectangular SVD). The square roots
of eigenvalues are used to build the biplot scaling, consistent with robust STATIS Dual.
}
\examples{
sim_batches <- simulate_pharma_batches()
phase1_data <- subset(sim_batches, Phase == "Phase 1" & Status == "Under Control")
phase2_data <- subset(sim_batches, Phase == "Phase 2")

phase1 <- robust_statis_phase1(
  data = phase1_data,
  variables = c("Concentration", "Humidity", "Dissolution", "Density")
)

phase2 <- robust_statis_phase2(
  new_data = phase2_data,
  variables = c("Concentration", "Humidity", "Dissolution", "Density"),
  medians = phase1$global_medians,
  mads = phase1$global_mads,
  compromise_matrix = phase1$compromise_matrix,
  global_center = phase1$global_center
)

plot_statis_biplot_projection(phase1, phase2)
}
