% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kobo_asset.R
\name{kobo_asset_list}
\alias{kobo_asset_list}
\title{List all available KoboToolbox API assets}
\usage{
kobo_asset_list(limit = 100L)
}
\arguments{
\item{limit}{integer, the number of API assets to display per page. Default to 100.}
}
\value{
A \code{data.frame} containing the list of all your KoboToolbox API assets
and the following metadata:
\itemize{
\item \code{uid} the asset unique identifier
\item \code{name} the name of the asset
\item \code{asset_type} the type of asset (\code{block}, \code{survey}, \code{question}, or \code{template})
\item \code{owner_userame} the user account of the owner of the asset
\item \code{date_create} when the asset was created
\item \code{date_modified} when the asset was last modified
\item \code{deployed} whether or not the asset is currently deployed
\item \code{submissions} the number of submissions for the asset (\code{survey})
}
}
\description{
List all available KoboToolbox API assets and their metadata.
}
\examples{
\dontrun{
kobo_setup()
asset_list <- kobo_asset_list(limit = 10L)
asset_list
}

}
