% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_flextable.R
\name{theme_mediation}
\alias{theme_mediation}
\title{Theme for formatting a flextable of results from (robust) mediation analysis}
\usage{
theme_mediation(x, ...)
}
\arguments{
\item{x}{an object of class \code{"\link[flextable]{flextable}"}.  It is
recommend to use this theme only for objects of subclass
\code{"mediation_flextable"}, as returned by \code{\link{to_flextable}()}.}

\item{\dots}{additional arguments are currently ignored.}
}
\value{
An object inheriting from class \code{"\link[flextable]{flextable}"}.
}
\description{
Apply a theme to a \code{\link[flextable]{flextable}} intended to format
results from (robust) mediation analysis.  The theme uses additional
information from subclass \code{"\link[=to_flextable]{mediation_flextable}"},
and it formats the table according to APA style.
}
\details{
Theme functions for \code{\link[flextable]{flextable}}s are not like
\pkg{ggplot2} themes, as they are applied to the existing table immediately.
For example, if you add a row in the footer after setting the theme, the new
row is not formatted with the theme.  The theme is applied only to existing
elements when the function is called.

That is, if you modify the table returned by \code{\link{to_flextable}()},
it may be necessary to apply the theme function again after all elements of
the table have been added (e.g., additional header or footer rows).
}
\examples{
data("BSG2014")

# perform mediation analysis via robust bootstrap test ROBMED
set.seed(20150601)
boot <- test_mediation(BSG2014,
                       x = "ValueDiversity",
                       y = "TeamCommitment",
                       m = "TaskConflict")

# construct flextable of results
ft <- to_flextable(boot)
# add additional row to the footer
footer_line <- flextable::as_paragraph(
  "Depending on the seed of the random number generator, the ",
  flextable::as_i("p"), " value of the indirect effect may ",
  "fall below or above the arbitrary 5\% threshold."
)
ft <- flextable::add_footer_lines(ft, values = footer_line)
ft <- theme_mediation(ft)
ft

}
\seealso{
\code{\link[flextable]{flextable}()}, \code{\link{to_flextable}()}
}
\author{
Andreas Alfons
}
