% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bpcTabWrapper.R
\name{bpcTabWrapper}
\alias{bpcTabWrapper}
\title{Backwards pivot coordinates and their inverse}
\usage{
bpcTabWrapper(
  X,
  obs.ID = NULL,
  row.factor = NULL,
  col.factor = NULL,
  value = NULL,
  base = exp(1)
)
}
\arguments{
\item{X}{object of class data.frame with columns corresponding to row and column factors of the respective compositional table, a variable with the values of the composition (positive values only) and a factor with observation IDs.}

\item{obs.ID}{name of the factor variable distinguishing the observations. Needs to be given with the quotation marks.}

\item{row.factor}{name of the variable representing the row factor. Needs to be given with the quotation marks.}

\item{col.factor}{name of the variable representing the column factor. Needs to be given with the quotation marks.}

\item{value}{name of the variable representing the values of the composition. Needs to be given with the quotation marks.}

\item{base}{a positive number: the base with respect to which logarithms are computed. Defaults to exp(1).}
}
\value{
\item{Coordinates}{array of orthonormal coordinates.} 
\item{Coordinates.ortg}{array of orthogonal coordinates.} 
\item{Contrast.matrix}{contrast matrix corresponding to the orthonormal coordinates.}
\item{Base}{the base with respect to which logarithms are computed.}
\item{Row.levels}{order of the row factor levels.}
\item{Col.levels}{order of the column factor levels.}
}
\description{
For each compositional table in the sample a system of backwards pivot coordinates is computed as a special case of isometric logratio coordinates. 
For their inverse mapping, the contrast matrix is provided.
}
\details{
bpcTabWrapper

Backwards pivot coordinates map IxJ-part compositional table from the simplex into a (IJ-1)-dimensional real space isometrically. 
Particularly the first coordinate from each group (rbpb.1, cbpb.1, tbpc.1) preserves the elemental information on the two-factorial structure. 
The first row and column backwards pivot balances rbpb.1 and cbpb.1 represent two-factorial counterparts to the pairwise logratios. 
More specifically, the first two levels of the considered factor are compared in the ratio, while the first level plays the role of the rationing category (denominator of the ratio) and the second level is treated as the normalized category (numerator of the ratio). All categories of the complementary factor are aggregated with the geometric mean.
The first table backwards pivot coordinate, has form of a four-part log odds-ratio (again related to the first two levels of the row and column factors) and quantifies the relations between factors.
All coordinates are structured as detailed in Nesrstova et al. (2023).
}
\examples{
data(manu_abs)
manu_abs$output <- as.factor(manu_abs$output)
manu_abs$isic <- as.factor(manu_abs$isic)

# default setting with ln()
bpcTabWrapper(manu_abs, obs.ID = "country", row.factor = "output", 
col.factor = "isic", value = "value")

# logarithm of base 2
bpcTabWrapper(manu_abs, obs.ID = "country", row.factor = "output", 
col.factor = "isic", value = "value", base = 2)

# for base exp(1) is the result similar to tabCoordWrapper():
r <- rbind(c(-1,1,0), c(-1,-1,1))
c <- rbind(c(-1,1,0,0,0), c(-1,-1,1,0,0), c(-1,-1,-1,1,0), c(-1,-1,-1,-1,1))
tabCoordWrapper(manu_abs, obs.ID = "country", row.factor = "output", 
col.factor = "isic", value = "value", SBPr = r, SBPc = c)
}
\references{
Nesrstova, V., Jaskova, P., Pavlu, I., Hron, K., Palarea-Albaladejo, J., Gaba, A., Pelclova, J., Facevicova, K. (2023). Simple enough, but not simpler: Reconsidering additive logratio coordinates in compositional analysis. Submitted
}
\seealso{
\code{\link{bpc}} 
\code{\link{bpcPcaTab}}
\code{\link{bpcRegTab}}
}
\author{
Kamila Facevicova
}
\keyword{multivariate}
