% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mzQC.R
\name{MzQCmzQC}
\alias{MzQCmzQC}
\alias{MzQCmzQC-class}
\title{Root element of an mzQC document}
\description{
Root element of an mzQC document

Root element of an mzQC document
}
\details{
At least one of runQualities or setQualities MUST be present.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{version}}{Version of the mzQC format.}

\item{\code{creationDate}}{Creation date of the mzQC file.}

\item{\code{contactName}}{Name of the operator/creator of this mzQC file.}

\item{\code{contactAddress}}{Contact address (mail/e-mail or phone)}

\item{\code{description}}{Description and comments about the mzQC file contents.}

\item{\code{runQualities}}{Array of MzQCrunQuality;}

\item{\code{setQualities}}{Array of MzQCsetQuality}

\item{\code{controlledVocabularies}}{Array of CV domains used (obo files)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MzQCmzQC-new}{\code{MzQCmzQC$new()}}
\item \href{#method-MzQCmzQC-isValid}{\code{MzQCmzQC$isValid()}}
\item \href{#method-MzQCmzQC-toJSON}{\code{MzQCmzQC$toJSON()}}
\item \href{#method-MzQCmzQC-fromData}{\code{MzQCmzQC$fromData()}}
\item \href{#method-MzQCmzQC-clone}{\code{MzQCmzQC$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MzQCmzQC-new"></a>}}
\if{latex}{\out{\hypertarget{method-MzQCmzQC-new}{}}}
\subsection{Method \code{new()}}{
Constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MzQCmzQC$new(
  version = NA_character_,
  creationDate = MzQCDateTime$new(),
  contactName = NA_character_,
  contactAddress = NA_character_,
  description = NA_character_,
  runQualities = list(),
  setQualities = list(),
  controlledVocabularies = list()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{version}}{String value for initialization of field version}

\item{\code{creationDate}}{MzQCDateTime value for initialization of field creationDate}

\item{\code{contactName}}{Optional string value for initialization of field contactName}

\item{\code{contactAddress}}{Optional string value for initialization of field contactAddress}

\item{\code{description}}{Optional string value for initialization of field description}

\item{\code{runQualities}}{Optional list value for initialization of field runQualities}

\item{\code{setQualities}}{Optional list value for initialization of field setQualities}

\item{\code{controlledVocabularies}}{Optional list value for initialization of field controlledVocabularies}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MzQCmzQC-isValid"></a>}}
\if{latex}{\out{\hypertarget{method-MzQCmzQC-isValid}{}}}
\subsection{Method \code{isValid()}}{
Verifies validity of the object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MzQCmzQC$isValid(context = "MzQCmzQC")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{context}}{Optional string describing location in mzQC structure that is used for more informative warning texts.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MzQCmzQC-toJSON"></a>}}
\if{latex}{\out{\hypertarget{method-MzQCmzQC-toJSON}{}}}
\subsection{Method \code{toJSON()}}{
Creates JSON file from this object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MzQCmzQC$toJSON(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional parameters for jsonlite:::asJSON()}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MzQCmzQC-fromData"></a>}}
\if{latex}{\out{\hypertarget{method-MzQCmzQC-fromData}{}}}
\subsection{Method \code{fromData()}}{
Sets data for this object from plain named lists of R objects
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MzQCmzQC$fromData(data, context = "MzQCmzQC")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A datastructure of R lists/arrays as obtained by 'jsonlite::fromJSON()'}

\item{\code{context}}{Optional string describing location in mzQC structure that is used for more informative warning texts.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MzQCmzQC-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MzQCmzQC-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MzQCmzQC$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
