% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptation.R
\name{scale_adapter}
\alias{scale_adapter}
\title{Create object to adapt proposal scale to coerce average acceptance rate.}
\usage{
scale_adapter(
  algorithm = "dual_averaging",
  initial_scale = NULL,
  target_accept_prob = NULL,
  ...
)
}
\arguments{
\item{algorithm}{String specifying algorithm to use. One of:
\itemize{
\item "stochastic_approximation" to use a Robbins-Monro (1951) based scheme,
\item "dual_averaging" to use dual-averaging scheme of Nesterov (2009).
}}

\item{initial_scale}{Initial value to use for scale parameter. If not set
explicitly a proposal and dimension dependent default will be used.}

\item{target_accept_prob}{Target value for average accept probability for
chain. If not set a proposal dependent default will be used.}

\item{...}{Any additional algorithmic parameters to pass through to
\code{\link[=dual_averaging_scale_adapter]{dual_averaging_scale_adapter()}} or \code{\link[=stochastic_approximation_scale_adapter]{stochastic_approximation_scale_adapter()}}.}
}
\value{
List of functions with entries
\itemize{
\item \code{initialize}, a function for initializing adapter state and proposal
parameters at beginning of chain,
\item \code{update} a function for updating adapter state and proposal parameters on
each chain iteration,
\item \code{finalize} a function for performing any final updates to adapter state and
proposal parameters on completion of chain sampling (may be \code{NULL} if
unused).
\item \code{state} a zero-argument function for accessing current values of adapter
state variables.
}
}
\description{
Create object to adapt proposal scale to coerce average acceptance rate.
}
\examples{
proposal <- barker_proposal()
adapter <- scale_adapter(initial_scale = 1., target_accept_prob = 0.4)
adapter$initialize(proposal, chain_state(c(0, 0)))
}
\references{
Nesterov, Y. (2009). Primal-dual subgradient methods for convex
problems. \emph{Mathematical Programming}, 120(1), 221-259.

Robbins, H., & Monro, S. (1951). A stochastic approximation
method. \emph{The Annals of Mathematical Statistics}, 400-407.
}
\seealso{
\code{\link[=dual_averaging_scale_adapter]{dual_averaging_scale_adapter()}}, \code{\link[=stochastic_approximation_scale_adapter]{stochastic_approximation_scale_adapter()}}
}
