% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/client_core.R
\name{rmangal_request}
\alias{rmangal_request}
\alias{rmangal_request_singleton}
\title{Low-level request function for the Mangal API}
\usage{
rmangal_request(endpoint, query = NULL, limit = 100, cache = FALSE, ...)

rmangal_request_singleton(endpoint, id, cache = FALSE, ...)
}
\arguments{
\item{endpoint}{A character string specifying the API endpoint to query.
Must be one of the endpoints listed in \code{\link[=rmangal_endpoints]{rmangal_endpoints()}}.}

\item{query}{Either a character string for a keyword search, or a named list
for custom queries. If \code{NULL}, all records are returned.}

\item{limit}{An integer specifying the maximum number of results per page.
Default is 100.}

\item{cache}{Logical or character. If \code{TRUE}, results are cached in a
temporary directory. If a character string, it specifies the cache
directory. If \code{FALSE} (default), no caching is used. See \code{\link[httr2:req_cache]{httr2::req_cache()}}
for further details about caching in this context.}

\item{...}{Additional arguments (currently ignored).}

\item{id}{An integer or character specifying the unique identifier of the
resource to retrieve. Must be a single value.}
}
\value{
An object of class \code{mgGetResponses} containing the response body
and the raw HTTP response(s).

An object of class \code{mgGetResponses} containing the response body
and the raw HTTP response.
}
\description{
These functions send a request to a specified endpoint of the Mangal API.
}
\section{Functions}{
\itemize{
\item \code{rmangal_request()}: Send a request to a specified endpoint of the
Mangal API and returns all matching results.

\item \code{rmangal_request_singleton()}: Retrieves a single resource by its ID from a
specified endpoint of the Mangal API.

}}
\examples{
\donttest{
# Search for networks with keyword "insect"
result <- rmangal_request("network", query = "insect", limit = 10)

# Custom query for a specific dataset
result <- rmangal_request("network", query = list(dataset_id = 19))
}
\donttest{
# Retrieve network with ID 5013
result <- rmangal_request_singleton("network", id = 5013)
}
}
